/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.swe.SweConstants;
import org.n52.shetland.w3c.soap.AbstractSoap;
import org.n52.shetland.w3c.soap.SoapConstants;
import org.n52.shetland.w3c.soap.SoapFault;
import org.n52.shetland.w3c.soap.SoapHeader;
import org.n52.shetland.w3c.soap.SoapRequest;
import org.n52.shetland.w3c.soap.SoapResponse;
import org.n52.svalbard.decode.AbstractSoapDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x2003.x05.soapEnvelope.Body;
import org.w3.x2003.x05.soapEnvelope.EnvelopeDocument;
import org.w3.x2003.x05.soapEnvelope.Header;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Soap12Decoder
extends AbstractSoapDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Soap12Decoder.class);

    public Soap12Decoder() {
        super("http://www.w3.org/2003/05/soap-envelope");
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(this.getKeys()));
    }

    @Override
    protected AbstractSoap<?> createEnvelope(XmlObject doc) throws DecodingException {
        AbstractSoap soap = null;
        String soapAction = "";
        if (doc instanceof EnvelopeDocument) {
            EnvelopeDocument envDoc = (EnvelopeDocument)doc;
            OwsServiceCommunicationObject bodyContent = this.getBodyContent(envDoc);
            AbstractSoap abstractSoap = soap = bodyContent instanceof OwsServiceRequest ? new SoapRequest("http://www.w3.org/2003/05/soap-envelope", "SOAP 1.2 Protocol").setBodyContent((OwsServiceCommunicationObject)((OwsServiceRequest)bodyContent)) : new SoapResponse("http://www.w3.org/2003/05/soap-envelope", "SOAP 1.2 Protocol").setBodyContent((OwsServiceCommunicationObject)((OwsServiceResponse)bodyContent));
            if (envDoc.getEnvelope().isSetHeader()) {
                soap.setSoapHeader(this.getSoapHeader(envDoc.getEnvelope().getHeader()));
            }
        } else {
            throw new UnsupportedDecoderInputException((Decoder)this, (Object)doc);
        }
        soap.setAction(this.checkSoapAction(soapAction, soap.getSoapHeader()));
        return soap;
    }

    @Override
    protected AbstractSoap<?> createFault(DecodingException de) {
        SoapFault fault = new SoapFault();
        fault.setFaultCode(SoapConstants.SENDER_FAULT);
        fault.setLocale(Locale.ENGLISH);
        fault.setFaultReason(this.getFaultReasons(de));
        SoapRequest r = new SoapRequest("http://www.w3.org/2003/05/soap-envelope", "SOAP 1.2 Protocol");
        r.setSoapFault(fault);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SoapHeader> getSoapHeader(Header header) {
        ArrayList soapHeaders = Lists.newArrayList();
        XmlCursor cursor = null;
        try {
            cursor = header.newCursor();
            if (cursor.toFirstChild()) {
                do {
                    Object object;
                    if ((object = this.decodeXmlElement(XmlObject.Factory.parse((String)cursor.xmlText(this.getXmlOptions())))) instanceof SoapHeader) {
                        soapHeaders.add((SoapHeader)object);
                        continue;
                    }
                    if (!(object instanceof List)) continue;
                    for (Object o : (List)object) {
                        if (!(o instanceof SoapHeader)) continue;
                        soapHeaders.add((SoapHeader)o);
                    }
                } while (cursor.toNextSibling());
            }
        }
        catch (XmlException | DecodingException e) {
            LOGGER.debug("Requested SoapHeader element is not supported", e);
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return soapHeaders;
    }

    private OwsServiceCommunicationObject getBodyContent(EnvelopeDocument doc) throws DecodingException {
        Body body = doc.getEnvelope().getBody();
        try {
            Node domNode = body.getDomNode();
            if (domNode.hasChildNodes()) {
                NodeList childNodes = domNode.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node node = childNodes.item(i);
                    if (node.getNodeType() != 1) continue;
                    XmlObject content = XmlObject.Factory.parse((Node)node);
                    Map namespaces = XmlHelper.getNamespaces((XmlObject)doc.getEnvelope());
                    this.fixNamespaceForXsiType(content, namespaces);
                    XmlHelper.fixNamespaceForXsiType((XmlObject)content, (QName)SweConstants.QN_DATA_ARRAY_PROPERTY_TYPE_SWE_200);
                    return (OwsServiceCommunicationObject)this.decodeXmlElement(content);
                }
            }
            return (OwsServiceCommunicationObject)this.decodeXmlElement((XmlObject)body);
        }
        catch (XmlException xmle) {
            throw new DecodingException("Error while parsing SOAP body element!", (Throwable)xmle);
        }
    }
}

