/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import eu.europa.ec.inspire.schemas.ef.x40.AbstractMonitoringFeatureType;
import eu.europa.ec.inspire.schemas.ef.x40.EnvironmentalMonitoringFacilityDocument;
import eu.europa.ec.inspire.schemas.ef.x40.EnvironmentalMonitoringFacilityType;
import net.opengis.gml.x32.FeaturePropertyType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.inspire.ef.AbstractMonitoringFeature;
import org.n52.shetland.inspire.ef.EnvironmentalMonitoringFacility;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.util.IdGenerator;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.svalbard.encode.AbstractMonitoringFeatureEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractEnvironmentalMonitoringFaciltityEncoder
extends AbstractMonitoringFeatureEncoder {
    @Override
    protected String generateGmlId() {
        return "emf_" + IdGenerator.generate((String)Double.toString((double)System.currentTimeMillis() * Math.random()));
    }

    @Override
    protected XmlObject createFeature(FeaturePropertyType featurePropertyType, AbstractFeature abstractFeature, EncodingContext context) throws EncodingException {
        if (context.has((Enum)XmlBeansEncodingFlags.ENCODE) && !context.getBoolean((Enum)XmlBeansEncodingFlags.ENCODE)) {
            featurePropertyType.setHref(abstractFeature.getIdentifierCodeWithAuthority().getValue());
            if (abstractFeature.isSetName()) {
                featurePropertyType.setTitle(abstractFeature.getFirstName().getValue());
            }
            return featurePropertyType;
        }
        EnvironmentalMonitoringFacilityType emft = this.createEnvironmentalMonitoringFaciltityType((EnvironmentalMonitoringFacility)abstractFeature);
        EnvironmentalMonitoringFacilityDocument emfd = EnvironmentalMonitoringFacilityDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        emfd.setEnvironmentalMonitoringFacility(emft);
        return emfd;
    }

    protected EnvironmentalMonitoringFacilityType createEnvironmentalMonitoringFaciltityType(EnvironmentalMonitoringFacility environmentalMonitoringFacility) throws EncodingException {
        EnvironmentalMonitoringFacilityType emft = EnvironmentalMonitoringFacilityType.Factory.newInstance();
        return this.encodeEnvironmentalMonitoringFaciltityType(emft, environmentalMonitoringFacility);
    }

    protected EnvironmentalMonitoringFacilityType encodeEnvironmentalMonitoringFaciltityType(EnvironmentalMonitoringFacilityType emft, EnvironmentalMonitoringFacility environmentalMonitoringFacility) throws EncodingException {
        this.encodeAbstractMonitoringFeature((AbstractMonitoringFeatureType)emft, (AbstractMonitoringFeature)environmentalMonitoringFacility);
        this.setRepresentativePoint(emft, environmentalMonitoringFacility);
        this.setMeasurementRegime(emft, environmentalMonitoringFacility);
        this.setMobile(emft, environmentalMonitoringFacility);
        this.setResultAcquisitionSource(emft, environmentalMonitoringFacility);
        this.setSpecialisedEMFType(emft, environmentalMonitoringFacility);
        this.setOperationalActivityPeriod(emft, environmentalMonitoringFacility);
        this.setRelatedTo(emft, environmentalMonitoringFacility);
        this.setBelongsTo(emft, environmentalMonitoringFacility);
        return emft;
    }

    private void setRepresentativePoint(EnvironmentalMonitoringFacilityType emft, EnvironmentalMonitoringFacility environmentalMonitoringFacility) throws EncodingException {
        if (environmentalMonitoringFacility.isSetRepresentativePoint()) {
            emft.addNewRepresentativePoint().addNewPoint().set(this.encodeGML32(environmentalMonitoringFacility.getRepresentativePoint()));
        }
    }

    private void setMeasurementRegime(EnvironmentalMonitoringFacilityType emft, EnvironmentalMonitoringFacility environmentalMonitoringFacility) throws EncodingException {
        if (environmentalMonitoringFacility.isSetMeasurementRegime()) {
            emft.addNewMeasurementRegime().set(this.encodeGML32(environmentalMonitoringFacility.getMeasurementRegime()));
        } else {
            emft.addNewMeasurementRegime().setNil();
        }
    }

    private void setMobile(EnvironmentalMonitoringFacilityType emft, EnvironmentalMonitoringFacility environmentalMonitoringFacility) {
        if (environmentalMonitoringFacility.isSetMobile()) {
            emft.addNewMobile().setBooleanValue(environmentalMonitoringFacility.isMobile());
        } else {
            emft.addNewMobile().setNil();
        }
    }

    private void setResultAcquisitionSource(EnvironmentalMonitoringFacilityType emft, EnvironmentalMonitoringFacility environmentalMonitoringFacility) throws EncodingException {
        if (environmentalMonitoringFacility.isSetResultAcquisitionSource()) {
            for (ReferenceType resultAcquisitionSource : environmentalMonitoringFacility.getResultAcquisitionSource()) {
                emft.addNewResultAcquisitionSource().set(this.encodeGML32(resultAcquisitionSource));
            }
        }
    }

    private void setSpecialisedEMFType(EnvironmentalMonitoringFacilityType emft, EnvironmentalMonitoringFacility environmentalMonitoringFacility) throws EncodingException {
        if (environmentalMonitoringFacility.isSetSpecialisedEMFType()) {
            emft.addNewSpecialisedEMFType().set(this.encodeGML32(environmentalMonitoringFacility.getSpecialisedEMFType()));
        }
    }

    private void setOperationalActivityPeriod(EnvironmentalMonitoringFacilityType emft, EnvironmentalMonitoringFacility envMoniFac) throws EncodingException {
        if (envMoniFac.isSetOperationalActivityPeriod()) {
            for (Referenceable operationalActivityPeriod : envMoniFac.getOperationalActivityPeriod()) {
                if (operationalActivityPeriod.isReference()) {
                    EnvironmentalMonitoringFacilityType.OperationalActivityPeriod oap = emft.addNewOperationalActivityPeriod();
                    oap.setHref(operationalActivityPeriod.getReference().getHref().toString());
                    if (!operationalActivityPeriod.getReference().getTitle().isPresent()) continue;
                    oap.setTitle(operationalActivityPeriod.getReference().getTitle().toString());
                    continue;
                }
                emft.addNewOperationalActivityPeriod().set(this.encodeEF(operationalActivityPeriod.getInstance().get()));
            }
        } else {
            emft.addNewOperationalActivityPeriod().setNil();
        }
    }

    private void setRelatedTo(EnvironmentalMonitoringFacilityType emft, EnvironmentalMonitoringFacility environmentalMonitoringFacility) throws EncodingException {
        if (environmentalMonitoringFacility.isSetRelatedTo()) {
            for (Referenceable relatedTo : environmentalMonitoringFacility.getRelatedTo()) {
                if (relatedTo.isReference()) {
                    EnvironmentalMonitoringFacilityType.RelatedTo rt = emft.addNewRelatedTo();
                    rt.setHref(relatedTo.getReference().getHref().toString());
                    if (!relatedTo.getReference().getTitle().isPresent()) continue;
                    rt.setTitle(relatedTo.getReference().getTitle().toString());
                    continue;
                }
                emft.addNewRelatedTo().addNewAnyDomainLink().set(this.encodeEF(relatedTo.getInstance().get()));
            }
        }
    }

    private void setBelongsTo(EnvironmentalMonitoringFacilityType emft, EnvironmentalMonitoringFacility environmentalMonitoringFacility) throws EncodingException {
        if (environmentalMonitoringFacility.isSetBelongsTo()) {
            for (Referenceable belongsTo : environmentalMonitoringFacility.getBelongsTo()) {
                if (belongsTo.isReference()) {
                    EnvironmentalMonitoringFacilityType.BelongsTo bt = emft.addNewBelongsTo();
                    bt.setHref(belongsTo.getReference().getHref().toString());
                    if (!belongsTo.getReference().getTitle().isPresent()) continue;
                    bt.setTitle(belongsTo.getReference().getTitle().toString());
                    continue;
                }
                emft.addNewBelongsTo().addNewNetworkFacility().set(this.encodeEF(belongsTo.getInstance().get()));
            }
        }
    }
}

