/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.opengis.gml.x32.DirectPositionListType;
import net.opengis.gml.x32.DiscreteCoverageType;
import net.opengis.gml.x32.LineStringDocument;
import net.opengis.gml.x32.LineStringType;
import net.opengis.gml.x33.ce.SimpleMultiPointDocument;
import net.opengis.gml.x33.ce.SimpleMultiPointType;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.function.Predicates;
import org.n52.shetland.ogc.om.values.ComparableValue;
import org.n52.shetland.ogc.om.values.DiscreteCoverage;
import org.n52.shetland.ogc.om.values.RectifiedGridCoverage;
import org.n52.shetland.ogc.om.values.Value;
import org.n52.shetland.ogc.swe.RangeValue;
import org.n52.svalbard.encode.AbstractCoverageEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractRectifiedGridCoverageTypeEncoder<T>
extends AbstractCoverageEncoder<T, RectifiedGridCoverage> {
    protected DiscreteCoverageType encodeRectifiedGridCoverage(RectifiedGridCoverage rectifiedGridCoverage, EncodingContext ec) throws EncodingException {
        DiscreteCoverageType dct = DiscreteCoverageType.Factory.newInstance();
        dct.setId(rectifiedGridCoverage.getGmlId());
        XmlObject encodedGeometry = this.encodeDomainSet(rectifiedGridCoverage);
        dct.addNewDomainSet().set(encodedGeometry);
        dct.setRangeSet(this.encodeRangeSet(dct, (DiscreteCoverage<?>)rectifiedGridCoverage));
        return dct;
    }

    private XmlObject encodeDomainSet(RectifiedGridCoverage rectifiedGridCoverage) {
        List domainSet = rectifiedGridCoverage.getDomainSet();
        if (!this.checkForRange(domainSet)) {
            SimpleMultiPointDocument smpd = SimpleMultiPointDocument.Factory.newInstance();
            SimpleMultiPointType smpt = smpd.addNewSimpleMultiPoint();
            smpt.setId("smp_" + rectifiedGridCoverage.getGmlId());
            DirectPositionListType dplt = smpt.addNewPosList();
            List<String> uoms = this.getUoms(domainSet);
            if (!uoms.isEmpty()) {
                dplt.setUomLabels((List)Lists.newArrayList(uoms));
            }
            dplt.setListValue(this.getList(rectifiedGridCoverage.getDomainSet()));
            return smpd;
        }
        LineStringDocument lsd = LineStringDocument.Factory.newInstance();
        LineStringType lst = lsd.addNewLineString();
        lst.setId("ls_" + rectifiedGridCoverage.getGmlId());
        lst.setUomLabels(this.getUoms(domainSet));
        for (ComparableValue quantityValued : domainSet) {
            Object value = quantityValued.getValue();
            if (value instanceof Double) {
                lst.addNewPos().setListValue((List)Lists.newArrayList((Object[])new Double[]{(Double)value}));
                continue;
            }
            if (!(value instanceof RangeValue)) continue;
            lst.addNewPos().setListValue(((RangeValue)value).getRangeAsList());
        }
        return lsd;
    }

    private List getList(List<ComparableValue<?, ?>> domainSet) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (ComparableValue<?, ?> quantityValued : domainSet) {
            if (!(quantityValued.getValue() instanceof Double)) continue;
            list.add((Double)quantityValued.getValue());
        }
        return list;
    }

    private boolean checkForRange(List<ComparableValue<?, ?>> domainSet) {
        return domainSet.stream().map(Value::getValue).anyMatch(Predicates.instanceOf(RangeValue.class));
    }

    private List<String> getUoms(List<ComparableValue<?, ?>> domainSet) {
        TreeSet uoms = Sets.newTreeSet();
        for (ComparableValue<?, ?> values : domainSet) {
            uoms.add(values.getUnit());
        }
        return Lists.newArrayList((Iterable)uoms);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        super.addNamespacePrefixToMap(nameSpacePrefixMap);
        nameSpacePrefixMap.put("http://www.opengis.net/gml/3.2", "gml");
    }
}

