/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.svalbard.encode.AbstractXmlResponseEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.OperationResponseEncoderKey;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResponseEncoder<T extends OwsServiceResponse>
extends AbstractXmlResponseEncoder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResponseEncoder.class);
    private final Set<EncoderKey> encoderKeys;

    public AbstractResponseEncoder(String service, String version, String operation, String namespace, String prefix, Class<T> responseType, boolean validate) {
        super(service, version, operation, namespace, prefix, responseType, validate);
        OwsOperationKey key = new OwsOperationKey(service, version, operation);
        this.encoderKeys = Sets.newHashSet((Object[])new EncoderKey[]{new XmlEncoderKey(namespace, responseType), new OperationResponseEncoderKey(key, MediaTypes.TEXT_XML), new OperationResponseEncoderKey(key, MediaTypes.APPLICATION_XML)});
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(this.encoderKeys));
    }

    public AbstractResponseEncoder(String service, String version, String operation, String namespace, String prefix, Class<T> responseType) {
        this(service, version, operation, namespace, prefix, responseType, false);
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(this.encoderKeys);
    }

    public void encode(T response, OutputStream outputStream, EncodingContext context) throws EncodingException {
        if (response == null) {
            throw new UnsupportedEncoderInputException((Encoder)this);
        }
        this.create(response, outputStream, context);
    }
}

