/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import eu.europa.ec.inspire.schemas.base2.x20.DocumentCitationType;
import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.joda.time.DateTime;
import org.n52.shetland.inspire.base2.DocumentCitation;
import org.n52.shetland.w3c.Nillable;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;

public class DocumentCitationTypeDecoder
extends AbstractXmlDecoder<XmlObject, DocumentCitation> {
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://inspire.ec.europa.eu/schemas/ompr/3.0", (Class[])new Class[]{DocumentCitationType.class});

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public DocumentCitation decode(XmlObject xmlObject) throws DecodingException {
        if (xmlObject instanceof DocumentCitationType) {
            DocumentCitation documentCitation = new DocumentCitation();
            DocumentCitationType dct = (DocumentCitationType)xmlObject;
            documentCitation.setDescription(dct.getDescription().getStringValue());
            if (dct.isNilDate()) {
                if (dct.getDate().isSetNilReason()) {
                    documentCitation.setDate(Nillable.nil((String)dct.getDate().getNilReason().toString()));
                }
            } else {
                documentCitation.setDate(new DateTime((Object)dct.getDate().getCIDate().getDate().getDate().getTime()));
            }
            if (dct.getLinkArray() != null) {
                for (DocumentCitationType.Link link : dct.getLinkArray()) {
                    if (link.isNil() && link.isSetNilReason()) {
                        documentCitation.addLink(Nillable.nil((String)link.getNilReason().toString()));
                        continue;
                    }
                    documentCitation.addLink(link.getStringValue());
                }
            }
            return documentCitation;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)xmlObject);
    }
}

