/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.math.BigInteger;
import java.util.Map;
import net.opengis.cv.x02.gml32.CVDiscretePointCoverageType;
import net.opengis.cv.x02.gml32.CVPointValuePairPropertyType;
import net.opengis.cv.x02.gml32.CVPointValuePairType;
import net.opengis.gml.x32.PointPropertyType;
import net.opengis.gml.x32.PointType;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlString;
import org.locationtech.jts.geom.Point;
import org.n52.shetland.ogc.om.PointValuePair;
import org.n52.shetland.ogc.om.values.BooleanValue;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.ComplexValue;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.CvDiscretePointCoverage;
import org.n52.shetland.ogc.om.values.GeometryValue;
import org.n52.shetland.ogc.om.values.HrefAttributeValue;
import org.n52.shetland.ogc.om.values.MultiPointCoverage;
import org.n52.shetland.ogc.om.values.NilTemplateValue;
import org.n52.shetland.ogc.om.values.ProfileValue;
import org.n52.shetland.ogc.om.values.QuantityRangeValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.RectifiedGridCoverage;
import org.n52.shetland.ogc.om.values.ReferenceValue;
import org.n52.shetland.ogc.om.values.SweDataArrayValue;
import org.n52.shetland.ogc.om.values.TLVTValue;
import org.n52.shetland.ogc.om.values.TVPValue;
import org.n52.shetland.ogc.om.values.TextValue;
import org.n52.shetland.ogc.om.values.TimeRangeValue;
import org.n52.shetland.ogc.om.values.TimeValue;
import org.n52.shetland.ogc.om.values.UnknownValue;
import org.n52.shetland.ogc.om.values.Value;
import org.n52.shetland.ogc.om.values.XmlValue;
import org.n52.shetland.ogc.om.values.visitor.ValueVisitor;
import org.n52.shetland.util.IdGenerator;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractCVDiscretePointCoverageTypeEncoder<T>
extends AbstractXmlEncoder<T, CvDiscretePointCoverage> {
    protected CVDiscretePointCoverageType encodeCVDiscretePointCoverage(CvDiscretePointCoverage cvDiscretePointCoverage) throws EncodingException {
        CVDiscretePointCoverageType cvdpct = CVDiscretePointCoverageType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        cvdpct.setId(cvDiscretePointCoverage.getGmlId());
        cvdpct.addNewDomainExtent().setHref(cvDiscretePointCoverage.getDomainExtent());
        cvdpct.addNewRangeType().setHref(cvDiscretePointCoverage.getRangeType().getHref());
        CVPointValuePairPropertyType cvpvppt = cvdpct.addNewElement();
        cvpvppt.setCVPointValuePair(this.encodePointValuePair(cvDiscretePointCoverage.getValue()));
        return cvdpct;
    }

    private CVPointValuePairType encodePointValuePair(PointValuePair value) throws EncodingException {
        CVPointValuePairType cvpvpt = CVPointValuePairType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        cvpvpt.setGeometry(this.encodeGeometry(value.getPoint(), IdGenerator.generate((String)value.toString())));
        if (value.isSetValue()) {
            cvpvpt.setValue(this.encodeValue(value.getValue()));
        } else {
            cvpvpt.addNewValue();
        }
        return cvpvpt;
    }

    private PointPropertyType encodeGeometry(Point point, String gmlId) throws EncodingException {
        PointPropertyType ppt = PointPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        ppt.setPoint((PointType)this.encodeGML(point, EncodingContext.of((Enum)XmlBeansEncodingFlags.GMLID, (Object)gmlId)));
        return ppt;
    }

    private XmlObject encodeValue(Value<?> value) throws EncodingException {
        return (XmlObject)value.accept((ValueVisitor)new ResultValueVisitor());
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        super.addNamespacePrefixToMap(nameSpacePrefixMap);
        nameSpacePrefixMap.put("http://www.opengis.net/cv/0.2/gml32", "cv");
    }

    protected XmlObject encodeGML(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o, ec);
    }

    protected XmlObject encodeGML(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o);
    }

    protected XmlObject encodeSWE(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o);
    }

    protected XmlObject encodeSWE(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o, ec);
    }

    protected XmlString createXmlString() {
        return XmlString.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    protected XmlInteger createXmlInteger() {
        return XmlInteger.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    protected XmlBoolean createXmlBoolean() {
        return XmlBoolean.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    private class ResultValueVisitor
    implements ValueVisitor<XmlObject, EncodingException> {
        ResultValueVisitor() {
        }

        public XmlObject visit(BooleanValue value) throws EncodingException {
            XmlBoolean xbBoolean = AbstractCVDiscretePointCoverageTypeEncoder.this.createXmlBoolean();
            if (value.isSetValue()) {
                xbBoolean.setBooleanValue(value.getValue().booleanValue());
            } else {
                xbBoolean.setNil();
            }
            return xbBoolean;
        }

        public XmlObject visit(CategoryValue value) throws EncodingException {
            if (value.isSetValue() && !value.getValue().isEmpty()) {
                return AbstractCVDiscretePointCoverageTypeEncoder.this.encodeGML(value);
            }
            return null;
        }

        public XmlObject visit(ComplexValue value) throws EncodingException {
            if (value.isSetValue()) {
                return AbstractCVDiscretePointCoverageTypeEncoder.this.encodeSWE(value.getValue(), EncodingContext.of((Enum)XmlBeansEncodingFlags.FOR_OBSERVATION, (Object)true));
            }
            return null;
        }

        public XmlObject visit(CountValue value) throws EncodingException {
            XmlInteger xbInteger = AbstractCVDiscretePointCoverageTypeEncoder.this.createXmlInteger();
            if (value.isSetValue() && value.getValue() != Integer.MIN_VALUE) {
                xbInteger.setBigIntegerValue(new BigInteger(value.getValue().toString()));
            } else {
                xbInteger.setNil();
            }
            return xbInteger;
        }

        public XmlObject visit(GeometryValue value) throws EncodingException {
            if (value.isSetValue()) {
                EncodingContext ec = EncodingContext.of((Enum)XmlBeansEncodingFlags.GMLID, (Object)("o_" + IdGenerator.generate((String)value.toString()))).with((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE, (Object)true);
                return AbstractCVDiscretePointCoverageTypeEncoder.this.encodeGML(value.getValue(), ec);
            }
            return null;
        }

        public XmlObject visit(HrefAttributeValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(NilTemplateValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(QuantityValue value) throws EncodingException {
            return AbstractCVDiscretePointCoverageTypeEncoder.this.encodeGML(value);
        }

        public XmlObject visit(ReferenceValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(SweDataArrayValue value) throws EncodingException {
            return AbstractCVDiscretePointCoverageTypeEncoder.this.encodeSWE(value.getValue(), EncodingContext.of((Enum)XmlBeansEncodingFlags.FOR_OBSERVATION, (Object)true));
        }

        public XmlObject visit(TVPValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(TLVTValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(TextValue value) throws EncodingException {
            XmlString xbString = AbstractCVDiscretePointCoverageTypeEncoder.this.createXmlString();
            if (value.isSetValue()) {
                xbString.setStringValue(value.getValue());
            } else {
                xbString.setNil();
            }
            return xbString;
        }

        public XmlObject visit(UnknownValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(CvDiscretePointCoverage value) throws EncodingException {
            return null;
        }

        public XmlObject visit(MultiPointCoverage value) throws EncodingException {
            return null;
        }

        public XmlObject visit(RectifiedGridCoverage value) throws EncodingException {
            return null;
        }

        public XmlObject visit(ProfileValue value) throws EncodingException {
            return AbstractCVDiscretePointCoverageTypeEncoder.this.encodeObjectToXml(value.getDefaultElementEncoding(), value);
        }

        public XmlObject visit(TimeValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(TimeRangeValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(XmlValue<?> value) throws EncodingException {
            if (value.getValue() instanceof XmlObject) {
                return (XmlObject)value.getValue();
            }
            return null;
        }

        public XmlObject visit(QuantityRangeValue value) throws EncodingException {
            return null;
        }
    }
}

