/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import net.opengis.sos.x20.InsertResultDocument;
import net.opengis.sos.x20.InsertResultType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlString;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.request.InsertResultRequest;
import org.n52.svalbard.encode.AbstractSwesRequestEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;

public class InsertResultRequestEncoder
extends AbstractSwesRequestEncoder<InsertResultRequest> {
    public InsertResultRequestEncoder() {
        super(Sos2Constants.Operations.InsertResult.name(), InsertResultRequest.class);
    }

    @Override
    protected XmlObject create(InsertResultRequest request) throws EncodingException {
        this.validateInput(request);
        InsertResultDocument doc = InsertResultDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        InsertResultType insertResult = doc.addNewInsertResult();
        insertResult.setService(request.getService());
        insertResult.setVersion(request.getVersion());
        insertResult.setTemplate(request.getTemplateIdentifier());
        this.addResultValues(request, insertResult);
        return doc;
    }

    private void addResultValues(InsertResultRequest request, InsertResultType insertResult) {
        XmlString xbString = XmlString.Factory.newInstance((XmlOptions)this.getXmlOptions());
        xbString.setStringValue(request.getResultValues());
        insertResult.setResultValues((XmlObject)xbString);
    }

    @Override
    protected void validateInput(InsertResultRequest request) throws UnsupportedEncoderInputException {
        super.validateInput(request);
        if (!request.isSetTemplateIdentifier()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "missing templateIdentifier");
        }
        if (!request.isSetResultValues() || request.getResultValues().isEmpty()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "missing resultValues");
        }
    }
}

