/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import net.opengis.sos.x20.InsertResultTemplateDocument;
import net.opengis.sos.x20.InsertResultTemplateType;
import net.opengis.sos.x20.ResultTemplateType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.request.InsertResultTemplateRequest;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.encoding.SweAbstractEncoding;
import org.n52.svalbard.encode.AbstractSwesRequestEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;

public class InsertResultTemplateRequestEncoder
extends AbstractSwesRequestEncoder<InsertResultTemplateRequest> {
    public InsertResultTemplateRequestEncoder() {
        super(Sos2Constants.Operations.InsertResultTemplate.name(), InsertResultTemplateRequest.class);
    }

    @Override
    protected XmlObject create(InsertResultTemplateRequest request) throws EncodingException {
        this.validateInput(request);
        InsertResultTemplateDocument doc = InsertResultTemplateDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        InsertResultTemplateType insertResultTemplate = doc.addNewInsertResultTemplate();
        insertResultTemplate.setService(request.getService());
        insertResultTemplate.setVersion(request.getVersion());
        ResultTemplateType resultTemplate = insertResultTemplate.addNewProposedTemplate().addNewResultTemplate();
        this.addIdentifier(resultTemplate, request);
        this.addOffering(resultTemplate, request);
        this.addObservationTemplate(resultTemplate, request);
        this.addResultStructure(resultTemplate, (SweAbstractDataComponent)request.getResultStructure().get().get());
        this.addResultEncoding(resultTemplate, (SweAbstractEncoding)request.getResultEncoding().get().get());
        return doc;
    }

    @Override
    protected void validateInput(InsertResultTemplateRequest request) throws UnsupportedEncoderInputException {
        super.validateInput(request);
        if (!request.isSetObservationTemplate()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "missing ObservationTemplate");
        }
        if (request.getObservationTemplate().getOfferings() == null || request.getObservationTemplate().getOfferings().size() != 1) {
            throw new UnsupportedEncoderInputException((Encoder)this, "missing offering");
        }
        if (!request.isSetResultStructure() || !request.getResultStructure().get().isPresent()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "missing resultStructure");
        }
        if (!request.isSetResultEncoding() || !request.getResultEncoding().get().isPresent()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "missing resultEncoding");
        }
    }

    private void addIdentifier(ResultTemplateType resultTemplate, InsertResultTemplateRequest request) {
        if (request.getIdentifier() != null && request.getIdentifier().getValue() != null && !request.getIdentifier().getValue().isEmpty()) {
            resultTemplate.setIdentifier(request.getIdentifier().getValue());
        }
    }

    private void addOffering(ResultTemplateType resultTemplate, InsertResultTemplateRequest request) {
        resultTemplate.setOffering((String)request.getObservationTemplate().getOfferings().iterator().next());
    }

    private void addObservationTemplate(ResultTemplateType resultTemplate, InsertResultTemplateRequest request) throws EncodingException {
        resultTemplate.addNewObservationTemplate().addNewOMObservation().set(this.encodeObjectToXml("http://www.opengis.net/om/2.0", request.getObservationTemplate(), EncodingContext.empty().with((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)));
    }

    private void addResultStructure(ResultTemplateType resultTemplate, SweAbstractDataComponent sweAbstractDataComponent) throws EncodingException {
        resultTemplate.addNewResultStructure().set(this.encodeObjectToXml("http://www.opengis.net/swe/2.0", sweAbstractDataComponent, EncodingContext.empty().with((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)));
    }

    private void addResultEncoding(ResultTemplateType resultTemplate, SweAbstractEncoding sweAbstractEncoding) throws EncodingException {
        resultTemplate.addNewResultEncoding().set(this.encodeObjectToXml("http://www.opengis.net/swe/2.0", sweAbstractEncoding, EncodingContext.empty().with((Enum)XmlBeansEncodingFlags.DOCUMENT)));
    }
}

