/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import eu.europa.ec.inspire.schemas.base2.x20.ContactType;
import eu.europa.ec.inspire.schemas.base2.x20.RelatedPartyType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.inspire.base2.Contact;
import org.n52.shetland.inspire.base2.RelatedParty;
import org.n52.shetland.w3c.Nillable;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.ClassToClassEncoderKey;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;

public class RelatedPartyTypeEncoder
extends AbstractXmlEncoder<XmlObject, RelatedParty> {
    private static final Set<EncoderKey> ENCODER_KEYS = Sets.newHashSet((Object[])new EncoderKey[]{new ClassToClassEncoderKey(RelatedPartyType.class, RelatedParty.class), new XmlEncoderKey("http://inspire.ec.europa.eu/schemas/base2/2.0", RelatedParty.class)});

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public XmlObject encode(RelatedParty relatedParty, EncodingContext context) throws EncodingException, UnsupportedEncoderInputException {
        return this.createRelatedParty(relatedParty);
    }

    private XmlObject createRelatedParty(RelatedParty relatedParty) throws EncodingException {
        RelatedPartyType rpt = RelatedPartyType.Factory.newInstance();
        this.addContact(rpt, relatedParty);
        this.addIndividualName(rpt, relatedParty);
        this.addOrganisationName(rpt, relatedParty);
        this.addPositionName(rpt, relatedParty);
        this.addRole(rpt, relatedParty);
        return rpt;
    }

    private void addContact(RelatedPartyType rpt, RelatedParty relatedParty) {
        if (relatedParty.isSetContact()) {
            rpt.addNewContact().setContact(this.createContact((Contact)relatedParty.getContact().get()));
        } else {
            rpt.setNilContact();
        }
    }

    private ContactType createContact(Contact contact) {
        ContactType ct = ContactType.Factory.newInstance();
        ct.addNewAddress().setNil();
        if (contact.getAddress().isNil() && contact.getAddress().getNilReason().isPresent()) {
            ct.getAddress().setNilReason(contact.getAddress().getNilReason().get());
        }
        ct.addNewContactInstructions();
        if (contact.getElectronicMailAddress().isPresent()) {
            ct.addNewElectronicMailAddress().setStringValue((String)contact.getElectronicMailAddress().get());
        } else if (contact.getElectronicMailAddress().isNil()) {
            ct.addNewElectronicMailAddress().setNil();
            if (contact.getElectronicMailAddress().getNilReason().isPresent()) {
                ct.getElectronicMailAddress().setNilReason(contact.getElectronicMailAddress().getNilReason().get());
            }
        }
        if (contact.getTelephoneFacsimile().isPresent()) {
            for (Nillable telephoneFacsimile : (List)contact.getTelephoneFacsimile().get()) {
                if (!telephoneFacsimile.isPresent()) continue;
                ct.addNewTelephoneFacsimile().setStringValue((String)telephoneFacsimile.get());
            }
        } else if (contact.getTelephoneFacsimile().isNil()) {
            ContactType.TelephoneFacsimile tf = ct.addNewTelephoneFacsimile();
            tf.setNil();
            if (contact.getTelephoneFacsimile().getNilReason().isPresent()) {
                tf.setNilReason(contact.getTelephoneFacsimile().getNilReason().get());
            }
        }
        if (contact.getTelephoneVoice().isPresent()) {
            for (Nillable telephoneVoice : (List)contact.getTelephoneVoice().get()) {
                if (!telephoneVoice.isPresent()) continue;
                ct.addNewTelephoneVoice().setStringValue((String)telephoneVoice.get());
            }
        } else if (contact.getTelephoneVoice().isNil()) {
            ContactType.TelephoneVoice tv = ct.addNewTelephoneVoice();
            tv.setNil();
            if (contact.getTelephoneVoice().getNilReason().isPresent()) {
                tv.setNilReason(contact.getTelephoneVoice().getNilReason().get());
            }
        }
        if (contact.getWebsite().isPresent()) {
            ct.addNewWebsite().setStringValue((String)contact.getWebsite().get());
        } else if (contact.getWebsite().isNil()) {
            ContactType.Website w = ct.addNewWebsite();
            w.setNil();
            if (contact.getWebsite().getNilReason().isPresent()) {
                w.setNilReason(contact.getWebsite().getNilReason().get());
            }
        }
        return ct;
    }

    private void addIndividualName(RelatedPartyType rpt, RelatedParty relatedParty) throws EncodingException {
        if (relatedParty.isSetIndividualName()) {
            rpt.addNewIndividualName().addNewPTFreeText().set(this.encodeGMD(relatedParty.getIndividualName()));
        }
    }

    private void addOrganisationName(RelatedPartyType rpt, RelatedParty relatedParty) throws EncodingException {
        if (relatedParty.isSetOrganisationName()) {
            rpt.addNewOrganisationName().addNewPTFreeText().set(this.encodeGMD(relatedParty.getOrganisationName()));
        }
    }

    private void addPositionName(RelatedPartyType rpt, RelatedParty relatedParty) throws EncodingException {
        if (relatedParty.isSetPositionName()) {
            rpt.addNewPositionName().addNewPTFreeText().set(this.encodeGMD(relatedParty.getPositionName()));
        }
    }

    private void addRole(RelatedPartyType rpt, RelatedParty relatedParty) throws EncodingException {
        if (relatedParty.isSetRole()) {
            for (Nillable role : relatedParty.getRoles()) {
                if (!role.isPresent()) continue;
                rpt.addNewRole().set(this.encodeGML(role.get()));
            }
        }
    }

    protected XmlObject encodeGML(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o);
    }

    protected XmlObject encodeGMD(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.isotc211.org/2005/gmd", o);
    }

    protected XmlObject encodeGMD(Object o, EncodingContext context) throws EncodingException {
        return this.encodeObjectToXml("http://www.isotc211.org/2005/gmd", o, context);
    }
}

