/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.w3c.wsdl.Definitions;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.StreamingEncoder;
import org.n52.svalbard.encode.StreamingEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.write.Wsdlv11XmlStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsdlEncoderv11
extends AbstractXmlEncoder<XmlObject, Definitions>
implements StreamingEncoder<XmlObject, Definitions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WsdlEncoderv11.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://schemas.xmlsoap.org/wsdl/", (Class[])new Class[]{Definitions.class});

    public WsdlEncoderv11() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    public MediaType getContentType() {
        return MediaTypes.APPLICATION_XML;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlObject encode(Definitions element, EncodingContext ctx) throws EncodingException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.encode(element, (OutputStream)baos, ctx);
            ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
            XmlObject xmlObject = XmlObject.Factory.parse((InputStream)in);
            return xmlObject;
        }
        catch (Exception e) {
            throw new EncodingException((Throwable)e);
        }
    }

    public void encode(Definitions element, OutputStream outputStream, EncodingContext ctx) throws EncodingException {
        try {
            if (!ctx.has((Enum)EncoderFlags.ENCODER_REPOSITORY)) {
                new Wsdlv11XmlStreamWriter(ctx.with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)StreamingEncoderFlags.EMBEDDED, (Object)false), outputStream, element).write();
            } else {
                new Wsdlv11XmlStreamWriter(ctx.with((Enum)StreamingEncoderFlags.EMBEDDED, (Object)false), outputStream, element).write();
            }
        }
        catch (XMLStreamException xmlse) {
            throw new EncodingException("Error while writing element to stream!", (Throwable)xmlse);
        }
    }
}

