/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Set;
import net.opengis.ogc.BBOXType;
import net.opengis.ogc.BinaryComparisonOpType;
import net.opengis.ogc.BinarySpatialOpType;
import net.opengis.ogc.BinaryTemporalOpType;
import net.opengis.ogc.ComparisonOpsType;
import net.opengis.ogc.LiteralType;
import net.opengis.ogc.PropertyIsBetweenType;
import net.opengis.ogc.PropertyIsLikeType;
import net.opengis.ogc.PropertyIsNullType;
import net.opengis.ogc.PropertyNameDocument;
import net.opengis.ogc.PropertyNameType;
import net.opengis.ogc.SpatialOperatorType;
import net.opengis.ogc.TemporalOperatorType;
import net.opengis.ogc.impl.BBOXTypeImpl;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.locationtech.jts.geom.Geometry;
import org.n52.shetland.ogc.filter.ComparisonFilter;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.sos.Sos1Constants;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OgcDecoderv100
extends AbstractXmlDecoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OgcDecoderv100.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/ogc", (Class[])new Class[]{SpatialOperatorType.class, TemporalOperatorType.class, BinarySpatialOpType.class, BinaryTemporalOpType.class, BBOXType.class, PropertyNameDocument.class});

    public OgcDecoderv100() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Object decode(XmlObject xmlObject) throws DecodingException {
        if (xmlObject instanceof BinaryTemporalOpType) {
            return this.parseTemporalOperatorType((BinaryTemporalOpType)xmlObject);
        }
        if (xmlObject instanceof TemporalOperatorType) {
            throw OgcDecoderv100.unsupportedTemporalFilterOperand();
        }
        if (xmlObject instanceof PropertyNameDocument) {
            PropertyNameDocument xbPropertyNameDoc = (PropertyNameDocument)xmlObject;
            return xbPropertyNameDoc.getPropertyName();
        }
        if (xmlObject instanceof BinarySpatialOpType) {
            return this.parseSpatialOperatorType((BinarySpatialOpType)xmlObject);
        }
        if (xmlObject instanceof BBOXType) {
            return this.parseBBOXFilterType((BBOXTypeImpl)xmlObject);
        }
        if (xmlObject instanceof ComparisonOpsType) {
            return this.parseComparisonOpsType((ComparisonOpsType)xmlObject);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, xmlObject);
    }

    private Object parseTemporalOperatorType(BinaryTemporalOpType xbBinaryTemporalOp) throws DecodingException {
        TemporalFilter temporalFilter = new TemporalFilter();
        String valueRef = "phenomenonTime";
        try {
            NodeList nodes = xbBinaryTemporalOp.getDomNode().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                FilterConstants.TimeOperator operator;
                if (nodes.item(i).getNamespaceURI() == null || nodes.item(i).getLocalName().equals("ValueReference")) continue;
                Object timeObject = this.decodeXmlElement(XmlObject.Factory.parse((Node)nodes.item(i)));
                if (timeObject instanceof PropertyNameType) {
                    PropertyNameType propertyNameType = (PropertyNameType)timeObject;
                }
                if (!(timeObject instanceof Time)) continue;
                Time time = (Time)timeObject;
                String localName = XmlHelper.getLocalName((XmlObject)xbBinaryTemporalOp);
                if (localName.equals(FilterConstants.TimeOperator.TM_During.name()) && time instanceof TimePeriod) {
                    operator = FilterConstants.TimeOperator.TM_During;
                } else if (localName.equals(FilterConstants.TimeOperator.TM_Equals.name()) && time instanceof TimeInstant) {
                    operator = FilterConstants.TimeOperator.TM_Equals;
                } else if (localName.equals(FilterConstants.TimeOperator.TM_After.name()) && time instanceof TimeInstant) {
                    operator = FilterConstants.TimeOperator.TM_After;
                } else if (localName.equals(FilterConstants.TimeOperator.TM_Before.name()) && time instanceof TimeInstant) {
                    operator = FilterConstants.TimeOperator.TM_Before;
                } else {
                    throw OgcDecoderv100.unsupportedTemporalFilterOperand();
                }
                temporalFilter.setOperator(operator);
                temporalFilter.setTime(time);
                temporalFilter.setValueReference(valueRef);
                break;
            }
        }
        catch (XmlException xmle) {
            throw new DecodingException("Error while parsing temporal filter!", (Throwable)xmle);
        }
        return temporalFilter;
    }

    private SpatialFilter parseBBOXFilterType(BBOXTypeImpl xbBBOX) throws DecodingException {
        SpatialFilter spatialFilter = new SpatialFilter();
        String valueRef = "om:featureOfInterest/sams:SF_SpatialSamplingFeature/sams:shape";
        try {
            spatialFilter.setOperator(FilterConstants.SpatialOperator.BBOX);
            XmlCursor geometryCursor = xbBBOX.newCursor();
            if (geometryCursor.toChild(GmlConstants.QN_ENVELOPE)) {
                Object sosGeometry = this.decodeXmlElement(XmlObject.Factory.parse((Node)geometryCursor.getDomNode()));
                if (sosGeometry instanceof Geometry) {
                    spatialFilter.setGeometry((Geometry)sosGeometry);
                    spatialFilter.setValueReference(valueRef);
                }
            } else {
                throw OgcDecoderv100.unsupportedSpatialFilterOperand();
            }
            geometryCursor.dispose();
        }
        catch (XmlException xmle) {
            throw OgcDecoderv100.errorParsingSpatialFilter(xmle);
        }
        return spatialFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object parseSpatialOperatorType(BinarySpatialOpType xbSpatialOpsType) throws DecodingException {
        SpatialFilter spatialFilter = new SpatialFilter();
        try {
            if (!(xbSpatialOpsType instanceof BBOXTypeImpl)) throw OgcDecoderv100.unsupportedSpatialFilter();
            spatialFilter.setOperator(FilterConstants.SpatialOperator.BBOX);
            BBOXTypeImpl xbBBOX = (BBOXTypeImpl)xbSpatialOpsType;
            spatialFilter.setOperator(FilterConstants.SpatialOperator.BBOX);
            XmlCursor geometryCursor = xbBBOX.newCursor();
            if (!geometryCursor.toChild(GmlConstants.QN_ENVELOPE)) throw OgcDecoderv100.unsupportedSpatialFilter();
            Object sosGeometry = this.decodeXmlElement(XmlObject.Factory.parse((Node)geometryCursor.getDomNode()));
            if (sosGeometry instanceof Geometry) {
                spatialFilter.setGeometry((Geometry)sosGeometry);
            }
            geometryCursor.dispose();
            return spatialFilter;
        }
        catch (XmlException xmle) {
            throw OgcDecoderv100.errorParsingSpatialFilter(xmle);
        }
    }

    private ComparisonFilter parseComparisonOpsType(ComparisonOpsType comparisonOpsType) throws DecodingException {
        if (comparisonOpsType instanceof BinaryComparisonOpType) {
            return this.parseBinaryComparisonFilter((BinaryComparisonOpType)comparisonOpsType);
        }
        if (comparisonOpsType instanceof PropertyIsLikeType) {
            return this.parsePropertyIsLikeFilter((PropertyIsLikeType)comparisonOpsType);
        }
        if (comparisonOpsType instanceof PropertyIsNullType) {
            return this.parsePropertyIsNullFilter((PropertyIsNullType)comparisonOpsType);
        }
        if (comparisonOpsType instanceof PropertyIsBetweenType) {
            return this.parsePropertyIsBetweenFilter((PropertyIsBetweenType)comparisonOpsType);
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)comparisonOpsType);
    }

    private ComparisonFilter parseBinaryComparisonFilter(BinaryComparisonOpType comparisonOpsType) throws DecodingException {
        ComparisonFilter comparisonFilter = new ComparisonFilter();
        String localName = XmlHelper.getLocalName((XmlObject)comparisonOpsType);
        if (FilterConstants.ComparisonOperator.PropertyIsEqualTo.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsEqualTo);
        } else if (FilterConstants.ComparisonOperator.PropertyIsNotEqualTo.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsNotEqualTo);
        } else if (FilterConstants.ComparisonOperator.PropertyIsLessThan.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsLessThan);
        } else if (FilterConstants.ComparisonOperator.PropertyIsGreaterThan.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsGreaterThan);
        } else if (FilterConstants.ComparisonOperator.PropertyIsLessThanOrEqualTo.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsLessThanOrEqualTo);
        } else if (FilterConstants.ComparisonOperator.PropertyIsGreaterThanOrEqualTo.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsGreaterThanOrEqualTo);
        } else {
            throw new UnsupportedDecoderInputException((Decoder)this, (Object)comparisonOpsType);
        }
        if (comparisonOpsType.isSetMatchCase()) {
            comparisonFilter.setMatchCase(comparisonOpsType.getMatchCase());
        }
        this.parseExpressions((XmlObject[])comparisonOpsType.getExpressionArray(), comparisonFilter);
        return comparisonFilter;
    }

    private ComparisonFilter parsePropertyIsLikeFilter(PropertyIsLikeType comparisonOpsType) throws DecodingException {
        try {
            ComparisonFilter comparisonFilter = new ComparisonFilter();
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsLike);
            comparisonFilter.setEscapeString(comparisonOpsType.getEscapeChar());
            comparisonFilter.setSingleChar(comparisonOpsType.getSingleChar());
            comparisonFilter.setWildCard(comparisonOpsType.getWildCard());
            comparisonFilter.setValueReference(this.parsePropertyName((XmlObject)comparisonOpsType.getPropertyName()));
            this.parseExpressions((XmlObject)comparisonOpsType.getLiteral(), comparisonFilter);
            return comparisonFilter;
        }
        catch (XmlException xmle) {
            throw new DecodingException("Error while parsing PropertyIsLikeType element!", (Throwable)xmle);
        }
    }

    private ComparisonFilter parsePropertyIsNullFilter(PropertyIsNullType comparisonOpsType) throws DecodingException {
        try {
            ComparisonFilter comparisonFilter = new ComparisonFilter();
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsNull);
            comparisonFilter.setValueReference(this.parsePropertyName((XmlObject)comparisonOpsType.getPropertyName()));
            return comparisonFilter;
        }
        catch (XmlException xmle) {
            throw new DecodingException("Error while parsing PropertyIsNullType element!", (Throwable)xmle);
        }
    }

    private ComparisonFilter parsePropertyIsBetweenFilter(PropertyIsBetweenType comparisonOpsType) throws DecodingException {
        ComparisonFilter comparisonFilter = new ComparisonFilter();
        comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsBetween);
        try {
            comparisonFilter.setValueReference(this.parsePropertyName((XmlObject)comparisonOpsType.getExpression()));
            comparisonFilter.setValue(this.parseStringFromExpression((XmlObject)comparisonOpsType.getLowerBoundary().getExpression()));
            comparisonFilter.setValueUpper(this.parseStringFromExpression((XmlObject)comparisonOpsType.getUpperBoundary().getExpression()));
        }
        catch (XmlException xmle) {
            throw new DecodingException("Error while parsing between filter element!", (Throwable)xmle);
        }
        return comparisonFilter;
    }

    private void parseExpressions(XmlObject[] expressionArray, ComparisonFilter comparisonFilter) throws DecodingException {
        for (XmlObject xmlObject : expressionArray) {
            this.parseExpressions(xmlObject, comparisonFilter);
        }
    }

    private void parseExpressions(XmlObject xmlObject, ComparisonFilter comparisonFilter) throws DecodingException {
        if (this.isPropertyNameExpression(xmlObject)) {
            try {
                comparisonFilter.setValueReference(this.parsePropertyName(xmlObject));
            }
            catch (XmlException xmle) {
                throw new DecodingException("Error while parsing propertyName element!", (Throwable)xmle);
            }
        } else if (xmlObject instanceof LiteralType) {
            comparisonFilter.setValue(this.parseLiteralValue((LiteralType)xmlObject));
        }
    }

    private String parseLiteralValue(LiteralType literalType) {
        return this.parseStringFromExpression((XmlObject)literalType);
    }

    private boolean isPropertyNameExpression(XmlObject xmlObject) {
        return "PropertyName".equals(XmlHelper.getLocalName((XmlObject)xmlObject));
    }

    private String parsePropertyName(XmlObject xmlObject) throws XmlException {
        PropertyNameDocument propertyName = PropertyNameDocument.Factory.parse((Node)xmlObject.getDomNode());
        return this.parseStringFromExpression((XmlObject)propertyName.getPropertyName());
    }

    private String parseStringFromExpression(XmlObject xmlObject) {
        return xmlObject.getDomNode().getFirstChild().getNodeValue().trim();
    }

    private static DecodingException unsupportedSpatialFilterOperand() {
        return new DecodingException("The requested spatial filter operand is not supported by this SOS!", new Object[0]);
    }

    private static DecodingException unsupportedSpatialFilter() {
        return new DecodingException("The requested spatial filter is not supported by this SOS!", new Object[0]);
    }

    private static DecodingException errorParsingSpatialFilter(XmlException xmle) {
        return new DecodingException("Error while parsing spatial filter!", (Throwable)xmle);
    }

    private static DecodingException unsupportedTemporalFilterOperand() {
        return new DecodingException((Enum)Sos1Constants.GetObservationParams.eventTime, "The requested temporal filter operand is not supported by this SOS!", new Object[0]);
    }
}

