/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.opengis.gml.x32.AbstractFeatureType;
import net.opengis.gml.x32.FeaturePropertyType;
import net.opengis.samplingSpecimen.x20.SFSpecimenDocument;
import net.opengis.samplingSpecimen.x20.SFSpecimenType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.locationtech.jts.geom.Geometry;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.AbstractGeometry;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.om.features.samplingFeatures.SfSpecimen;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.sos.FeatureType;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.SamplingDecoderv20;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpecimenDecoderv20
extends SamplingDecoderv20 {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpecimenDecoderv20.class);
    private static final Set<SupportedType> SUPPORTED_TYPES = Sets.newHashSet((Object[])new SupportedType[]{new FeatureType("http://www.opengis.net/def/nil/OGC/0/unknown"), new FeatureType("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_Specimen")});
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/samplingSpecimen/2.0", (Class[])new Class[]{SFSpecimenDocument.class, SFSpecimenType.class});

    public SpecimenDecoderv20() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    @Override
    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    @Override
    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    @Override
    public AbstractFeature decode(XmlObject element) throws DecodingException {
        XmlHelper.validateDocument((XmlObject)element);
        if (element instanceof SFSpecimenDocument) {
            return this.parseSpatialSamplingFeature(((SFSpecimenDocument)element).getSFSpecimen());
        }
        if (element instanceof SFSpecimenType) {
            return this.parseSpatialSamplingFeature((SFSpecimenType)element);
        }
        return super.decode(element);
    }

    private AbstractFeature parseSpatialSamplingFeature(SFSpecimenType sfst) throws DecodingException {
        SfSpecimen specimen = new SfSpecimen(null, sfst.getId());
        this.parseAbstractFeatureType((AbstractFeatureType)sfst, (AbstractFeature)specimen);
        specimen.setSampledFeatures(this.getSampledFeatures(sfst.getSampledFeatureArray()));
        specimen.setXml(this.getXmlDescription(sfst));
        if (sfst.getParameterArray() != null) {
            specimen.setParameters(this.parseNamedValueTypeArray(sfst.getParameterArray()));
        }
        sfst.getMaterialClass();
        specimen.setMaterialClass((ReferenceType)this.decodeXmlElement((XmlObject)sfst.getMaterialClass()));
        specimen.setSamplingTime(this.getSamplingTime(sfst));
        if (sfst.isSetSamplingLocation()) {
            specimen.setSamplingLocation(this.getGeometry(sfst));
        }
        if (sfst.isSetSize()) {
            specimen.setSize(this.getSize(sfst.getSize()));
        }
        if (sfst.isSetSpecimenType()) {
            specimen.setSpecimenType((ReferenceType)this.decodeXmlElement((XmlObject)sfst.getSpecimenType()));
        }
        return specimen;
    }

    private Time getSamplingTime(SFSpecimenType sfst) throws DecodingException {
        Object decodedObject;
        if (sfst.getSamplingTime().isSetAbstractTimeObject() && (decodedObject = this.decodeXmlObject((XmlObject)sfst.getSamplingTime().getAbstractTimeObject())) instanceof Time) {
            return (Time)decodedObject;
        }
        return null;
    }

    private QuantityValue getSize(SFSpecimenType.Size size) {
        QuantityValue quantityValue = new QuantityValue(Double.valueOf(size.getDoubleValue()));
        quantityValue.setUnit(size.getUom());
        return quantityValue;
    }

    private String getXmlDescription(SFSpecimenType sfst) {
        SFSpecimenDocument sfsd = SFSpecimenDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        sfsd.setSFSpecimen(sfst);
        return sfsd.xmlText(this.getXmlOptions());
    }

    private List<AbstractFeature> getSampledFeatures(FeaturePropertyType[] sampledFeatureArray) throws DecodingException {
        ArrayList sampledFeatures = Lists.newArrayList();
        for (FeaturePropertyType featurePropertyType : sampledFeatureArray) {
            sampledFeatures.addAll(this.getSampledFeatures(featurePropertyType));
        }
        return sampledFeatures;
    }

    private List<AbstractFeature> getSampledFeatures(FeaturePropertyType sampledFeature) throws DecodingException {
        ArrayList<AbstractFeature> sampledFeatures = new ArrayList<AbstractFeature>(1);
        if (sampledFeature != null && !sampledFeature.isNil()) {
            if (sampledFeature.getHref() != null && !sampledFeature.getHref().isEmpty()) {
                if (sampledFeature.getHref().startsWith("#")) {
                    sampledFeatures.add((AbstractFeature)new SamplingFeature(null, sampledFeature.getHref().replace("#", "")));
                } else {
                    SamplingFeature sampFeat = new SamplingFeature(new CodeWithAuthority(sampledFeature.getHref()));
                    if (sampledFeature.getTitle() != null && !sampledFeature.getTitle().isEmpty()) {
                        sampFeat.addName(new CodeType(sampledFeature.getTitle()));
                    }
                    sampledFeatures.add((AbstractFeature)sampFeat);
                }
            } else {
                Object decodedObject;
                AbstractFeatureType abstractFeature = null;
                if (sampledFeature.getAbstractFeature() != null) {
                    abstractFeature = sampledFeature.getAbstractFeature();
                } else if (sampledFeature.getDomNode().hasChildNodes()) {
                    try {
                        abstractFeature = XmlObject.Factory.parse((Node)XmlHelper.getNodeFromNodeList((NodeList)sampledFeature.getDomNode().getChildNodes()));
                    }
                    catch (XmlException xmle) {
                        throw new DecodingException("Error while parsing feature request!", (Throwable)xmle);
                    }
                }
                if (abstractFeature != null && (decodedObject = this.decodeXmlObject((XmlObject)abstractFeature)) instanceof AbstractFeature) {
                    sampledFeatures.add((AbstractFeature)decodedObject);
                }
                throw new DecodingException("The requested sampledFeature type is not supported by this service!", new Object[0]);
            }
        }
        return sampledFeatures;
    }

    private Geometry getGeometry(SFSpecimenType sfst) throws DecodingException {
        Object decodedObject = this.decodeXmlElement((XmlObject)sfst.getSamplingLocation());
        if (decodedObject instanceof Geometry) {
            return (Geometry)decodedObject;
        }
        if (decodedObject instanceof AbstractGeometry) {
            return ((AbstractGeometry)decodedObject).getGeometry();
        }
        throw new DecodingException("The requested geometry type of featureOfInterest is not supported by this service!", new Object[0]);
    }
}

