/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.wsa.WsaActionHeader;
import org.n52.shetland.w3c.wsa.WsaHeader;
import org.n52.shetland.w3c.wsa.WsaMessageIDHeader;
import org.n52.shetland.w3c.wsa.WsaRelatesToHeader;
import org.n52.shetland.w3c.wsa.WsaReplyToHeader;
import org.n52.shetland.w3c.wsa.WsaToHeader;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x2005.x08.addressing.ActionDocument;
import org.w3.x2005.x08.addressing.MessageIDDocument;
import org.w3.x2005.x08.addressing.RelatesToDocument;
import org.w3.x2005.x08.addressing.ReplyToDocument;
import org.w3.x2005.x08.addressing.ToDocument;

public class WsaDecoder
extends AbstractXmlDecoder<XmlObject, WsaHeader> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WsaDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.w3.org/2005/08/addressing", (Class[])new Class[]{ToDocument.class, ActionDocument.class, MessageIDDocument.class, RelatesToDocument.class, ReplyToDocument.class})});

    public WsaDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public WsaHeader decode(XmlObject element) throws DecodingException {
        if (element instanceof ToDocument) {
            return this.parseToDocument((ToDocument)element);
        }
        if (element instanceof ActionDocument) {
            return this.parseActionDocument((ActionDocument)element);
        }
        if (element instanceof MessageIDDocument) {
            return this.parseMessageIDDocument((MessageIDDocument)element);
        }
        if (element instanceof RelatesToDocument) {
            return this.parseRelatesToDocument((RelatesToDocument)element);
        }
        if (element instanceof ReplyToDocument) {
            return this.parseReplyToDocument((ReplyToDocument)element);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, element);
    }

    private WsaHeader parseToDocument(ToDocument element) {
        return new WsaToHeader(element.getTo().getStringValue());
    }

    private WsaHeader parseActionDocument(ActionDocument element) {
        return new WsaActionHeader(element.getAction().getStringValue());
    }

    private WsaHeader parseMessageIDDocument(MessageIDDocument element) {
        return new WsaMessageIDHeader(element.getMessageID().getStringValue());
    }

    private WsaHeader parseRelatesToDocument(RelatesToDocument element) {
        return new WsaRelatesToHeader(element.getRelatesTo().getStringValue());
    }

    private WsaHeader parseReplyToDocument(ReplyToDocument element) {
        return new WsaReplyToHeader(element.getReplyTo().getAddress().getStringValue());
    }
}

