/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.opengis.om.x20.OMObservationType;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.om.ObservationType;
import org.n52.svalbard.encode.AbstractWmlEncoderv20;

public abstract class AbstractOmInspireEncoder
extends AbstractWmlEncoderv20 {
    private static final Map<String, Map<String, Set<String>>> SUPPORTED_RESPONSE_FORMATS = Collections.singletonMap("SOS", Collections.singletonMap("2.0.0", Collections.singleton("http://inspire.ec.europa.eu/schemas/omso/3.0")));

    @Override
    public boolean isObservationAndMeasurmentV20Type() {
        return true;
    }

    @Override
    public boolean shouldObservationsWithSameXBeMerged() {
        return false;
    }

    public boolean supportsResultStreamingForMergedValues() {
        return false;
    }

    public Set<String> getSupportedResponseFormats(String service, String version) {
        if (SUPPORTED_RESPONSE_FORMATS.get(service) != null && SUPPORTED_RESPONSE_FORMATS.get(service).get(version) != null) {
            return SUPPORTED_RESPONSE_FORMATS.get(service).get(version);
        }
        return new HashSet<String>(0);
    }

    @Override
    public String getDefaultFeatureEncodingNamespace() {
        return "http://www.opengis.net/samplingSpatial/2.0";
    }

    @Override
    protected String getDefaultProcedureEncodingNamspace() {
        return "http://www.opengis.net/sensorML/1.0.1";
    }

    @Override
    protected boolean convertEncodedProcedure() {
        return false;
    }

    @Override
    protected void addObservationType(OMObservationType xbObservation, String observationType) {
        xbObservation.addNewType().setHref(this.getObservationType());
    }

    @Override
    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        super.addNamespacePrefixToMap(nameSpacePrefixMap);
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/base/3.3", "base");
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/omor/3.0", "omor");
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/omso/3.0", "omso");
    }

    public Map<String, Set<SupportedType>> getSupportedResponseFormatObservationTypes() {
        return Collections.singletonMap("http://inspire.ec.europa.eu/schemas/omso/3.0", this.getSupportedTypes());
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(Sets.newHashSet((Object[])new ObservationType[]{new ObservationType(this.getObservationType())}));
    }

    protected abstract String getObservationType();
}

