/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Set;
import net.opengis.fes.x20.SpatialOpsDocument;
import net.opengis.sos.x20.GetFeatureOfInterestDocument;
import net.opengis.sos.x20.GetFeatureOfInterestType;
import net.opengis.swes.x20.ExtensibleRequestType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.request.GetFeatureOfInterestRequest;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractSosRequestEncoder;
import org.n52.svalbard.encode.ExtensibleRequestEncoder;
import org.n52.svalbard.encode.exception.EncodingException;

public class GetFeatureOfInterestRequestEncoder
extends AbstractSosRequestEncoder<GetFeatureOfInterestRequest>
implements ExtensibleRequestEncoder {
    public GetFeatureOfInterestRequestEncoder() {
        super(SosConstants.Operations.GetFeatureOfInterest.name(), GetFeatureOfInterestRequest.class);
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{Sos2Constants.SOS_GET_OBSERVATION_SCHEMA_LOCATION});
    }

    @Override
    protected XmlObject create(GetFeatureOfInterestRequest request) throws EncodingException {
        GetFeatureOfInterestDocument doc = GetFeatureOfInterestDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        GetFeatureOfInterestType gfoit = doc.addNewGetFeatureOfInterest();
        this.addService((ExtensibleRequestType)gfoit, (OwsServiceRequest)request);
        this.addVersion((ExtensibleRequestType)gfoit, (OwsServiceRequest)request);
        this.addExtension((ExtensibleRequestType)gfoit, (OwsServiceRequest)request);
        this.addProcedure(gfoit, request);
        this.addObservedProperty(gfoit, request);
        this.addFeatureOfInterest(gfoit, request);
        this.addSpatialFilters(gfoit, request);
        return doc;
    }

    private void addProcedure(GetFeatureOfInterestType gfoit, GetFeatureOfInterestRequest request) {
        if (request.isSetProcedures()) {
            request.getProcedures().forEach(arg_0 -> ((GetFeatureOfInterestType)gfoit).addProcedure(arg_0));
        }
    }

    private void addObservedProperty(GetFeatureOfInterestType gfoit, GetFeatureOfInterestRequest request) {
        if (request.isSetObservableProperties()) {
            request.getObservedProperties().forEach(arg_0 -> ((GetFeatureOfInterestType)gfoit).addObservedProperty(arg_0));
        }
    }

    private void addFeatureOfInterest(GetFeatureOfInterestType gfoit, GetFeatureOfInterestRequest request) {
        if (request.isSetFeatureOfInterestIdentifiers()) {
            request.getFeatureIdentifiers().forEach(arg_0 -> ((GetFeatureOfInterestType)gfoit).addFeatureOfInterest(arg_0));
        }
    }

    private void addSpatialFilters(GetFeatureOfInterestType got, GetFeatureOfInterestRequest request) throws EncodingException {
        if (request.isSetSpatialFilters()) {
            for (SpatialFilter spatialFilter : request.getSpatialFilters()) {
                XmlObject encodeFes = this.encodeFes(spatialFilter);
                if (!(encodeFes instanceof SpatialOpsDocument)) continue;
                this.substitute((XmlObject)got.addNewSpatialFilter().getSpatialOps(), (XmlObject)((SpatialOpsDocument)encodeFes).getSpatialOps());
            }
        }
    }
}

