/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import eu.europa.ec.inspire.schemas.ompr.x30.ProcessDocument;
import eu.europa.ec.inspire.schemas.ompr.x30.ProcessPropertyType;
import eu.europa.ec.inspire.schemas.ompr.x30.ProcessType;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.opengis.gml.x32.FeaturePropertyType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.inspire.base2.DocumentCitation;
import org.n52.shetland.inspire.base2.RelatedParty;
import org.n52.shetland.inspire.ompr.InspireOMPRConstants;
import org.n52.shetland.inspire.ompr.Process;
import org.n52.shetland.inspire.ompr.ProcessParameter;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.sos.ProcedureDescriptionFormat;
import org.n52.shetland.ogc.sos.SosProcedureDescription;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.util.IdGenerator;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractGmlEncoderv321;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ProcedureEncoder;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTypeEncoder
extends AbstractGmlEncoderv321<XmlObject, Process>
implements ProcedureEncoder<XmlObject, Process> {
    private final Logger LOGGER = LoggerFactory.getLogger(ProcessTypeEncoder.class);
    private final Set<SupportedType> SUPPORTED_TYPES = Sets.newHashSet((Object[])new SupportedType[]{new ProcedureDescriptionFormat("http://inspire.ec.europa.eu/schemas/ompr/3.0"), new ProcedureDescriptionFormat(InspireOMPRConstants.OMPR_30_OUTPUT_FORMAT_MIME_TYPE)});
    private final Map<String, ImmutableMap<String, Set<String>>> SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS = ImmutableMap.of((Object)"SOS", (Object)ImmutableMap.builder().put((Object)"2.0.0", (Object)ImmutableSet.of((Object)"http://inspire.ec.europa.eu/schemas/ompr/3.0")).put((Object)"1.0.0", (Object)ImmutableSet.of((Object)InspireOMPRConstants.OMPR_30_OUTPUT_FORMAT_MIME_TYPE)).build());
    private final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://inspire.ec.europa.eu/schemas/ompr/3.0", (Class[])new Class[]{SosProcedureDescription.class, Process.class}), CodingHelper.encoderKeysForElements((String)InspireOMPRConstants.OMPR_30_OUTPUT_FORMAT_MIME_TYPE, (Class[])new Class[]{SosProcedureDescription.class, Process.class}), CodingHelper.encoderKeysForElements((String)"http://inspire.ec.europa.eu/featureconcept/Process", (Class[])new Class[]{SosProcedureDescription.class, Process.class})});

    public ProcessTypeEncoder() {
        this.LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(this.ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(this.ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(this.SUPPORTED_TYPES);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/ompr/3.0", "ompr");
    }

    @Override
    public MediaType getContentType() {
        return InspireOMPRConstants.OMPR_30_CONTENT_TYPE;
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{InspireOMPRConstants.OMPR_SCHEMA_LOCATION});
    }

    public Set<String> getSupportedProcedureDescriptionFormats(String service, String version) {
        if (this.SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS.containsKey(service) && this.SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS.get(service).containsKey((Object)version)) {
            return (Set)this.SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS.get(service).get((Object)version);
        }
        return Collections.emptySet();
    }

    @Override
    public XmlObject encode(Process process) throws EncodingException {
        return this.encode(process, EncodingContext.empty());
    }

    public XmlObject encode(Process process, EncodingContext ec) throws EncodingException {
        return this.createProcess(process);
    }

    protected ProcessType createProcess(Process process) throws EncodingException {
        if (process.isSetXml()) {
            XmlObject encodedObject = null;
            try {
                encodedObject = XmlObject.Factory.parse((String)process.getXml());
                if (encodedObject instanceof ProcessType) {
                    ProcessType pt = (ProcessType)encodedObject;
                    this.checkForInspireId(pt, process);
                    return pt;
                }
                if (encodedObject instanceof ProcessDocument) {
                    return ((ProcessDocument)encodedObject).getProcess();
                }
                if (encodedObject instanceof ProcessPropertyType) {
                    return ((ProcessPropertyType)encodedObject).getProcess();
                }
                throw new UnsupportedEncoderInputException((Encoder)this, (Object)process);
            }
            catch (XmlException xmle) {
                throw new EncodingException((Throwable)xmle);
            }
        }
        ProcessType pt = ProcessType.Factory.newInstance();
        if (!process.isSetGmlID()) {
            process.setGmlId("p_" + IdGenerator.generate((String)process.toString()));
        }
        pt.setId(process.getGmlId());
        this.addInspireId(pt, process);
        this.addName(pt, process);
        this.addType(pt, process);
        this.addDocumentation(pt, process);
        this.addProcessParameter(pt, process);
        this.addResponsibleParty(pt, process);
        return pt;
    }

    private void checkForInspireId(ProcessType pt, Process process) throws EncodingException {
        if (pt.getInspireId() == null) {
            if (process.isSetIdentifier()) {
                this.addInspireId(pt, process);
            } else {
                ProcessType.InspireId iId = pt.addNewInspireId();
                iId.setNil();
                iId.setNilReason((Object)"unknown");
            }
        }
    }

    private void addInspireId(ProcessType pt, Process process) throws EncodingException {
        pt.addNewInspireId().set(this.encodeBASEPropertyType(process.getInspireId()));
    }

    private void addName(ProcessType pt, Process process) {
        if (process.isSetName()) {
            pt.addNewName2().setStringValue(process.getFirstName().getValue());
        }
    }

    private void addType(ProcessType pt, Process process) {
        if (process.isSetType()) {
            pt.addNewType().setStringValue(process.getType());
        } else {
            pt.addNewType().setNil();
        }
    }

    private void addDocumentation(ProcessType pt, Process process) throws EncodingException {
        if (process.isSetDocumentation()) {
            for (DocumentCitation documentCitation : process.getDocumentation()) {
                pt.addNewDocumentation().addNewDocumentCitation().set(this.encodeBASE2(documentCitation));
            }
        }
    }

    private void addProcessParameter(ProcessType pt, Process process) throws EncodingException {
        if (process.isSetProcessParameter()) {
            for (ProcessParameter processParameter : process.getProcessParameter()) {
                pt.addNewProcessParameter().addNewProcessParameter().set(this.encodeOMPR(processParameter));
            }
        }
    }

    private void addResponsibleParty(ProcessType pt, Process process) throws EncodingException {
        if (process.isSetResponsibleParty()) {
            for (RelatedParty relatedParty : process.getResponsibleParty()) {
                pt.addNewResponsibleParty().addNewRelatedParty().set(this.encodeBASE2(relatedParty));
            }
        }
    }

    @Override
    protected XmlObject createFeature(FeaturePropertyType featurePropertyType, AbstractFeature abstractFeature, EncodingContext context) throws EncodingException {
        if (context.has((Enum)XmlBeansEncodingFlags.ENCODE) && !context.getBoolean((Enum)XmlBeansEncodingFlags.ENCODE)) {
            featurePropertyType.setHref(abstractFeature.getIdentifierCodeWithAuthority().getValue());
            if (abstractFeature.isSetName()) {
                featurePropertyType.setTitle(abstractFeature.getFirstName().getValue());
            }
            return featurePropertyType;
        }
        return this.encodeOMPRDocument(abstractFeature);
    }

    protected XmlObject encodeOMPR(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://inspire.ec.europa.eu/schemas/ompr/3.0", o);
    }

    protected XmlObject encodeOMPRDocument(Object o) throws EncodingException {
        return this.encodeObjectToXmlDocument("http://inspire.ec.europa.eu/schemas/base/3.3", o);
    }

    protected XmlObject encodeBASE(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://inspire.ec.europa.eu/schemas/base/3.3", o);
    }

    protected XmlObject encodeBASE(Object o, EncodingContext encodingContext) throws EncodingException {
        return this.encodeObjectToXml("http://inspire.ec.europa.eu/schemas/base/3.3", o, encodingContext);
    }

    protected XmlObject encodeBASEPropertyType(Object o) throws EncodingException {
        return this.encodeObjectToXmlPropertyType("http://inspire.ec.europa.eu/schemas/base/3.3", o);
    }

    protected XmlObject encodeBASEDocument(Object o) throws EncodingException {
        return this.encodeObjectToXmlDocument("http://inspire.ec.europa.eu/schemas/base/3.3", o);
    }

    protected XmlObject encodeBASE2(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://inspire.ec.europa.eu/schemas/base2/2.0", o);
    }

    protected XmlObject encodeBASE2(Object o, EncodingContext encodingContext) throws EncodingException {
        return this.encodeObjectToXml("http://inspire.ec.europa.eu/schemas/base2/2.0", o, encodingContext);
    }

    protected XmlObject encodeBASE2PropertyType(Object o) throws EncodingException {
        return this.encodeObjectToXmlPropertyType("http://inspire.ec.europa.eu/schemas/base2/2.0", o);
    }

    protected XmlObject encodeBASE2Document(Object o) throws EncodingException {
        return this.encodeObjectToXmlDocument("http://inspire.ec.europa.eu/schemas/base2/2.0", o);
    }
}

