/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.rdf.RDF;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.StreamingEncoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.write.RdfStreamWriter;

public class RdfEncoder
implements StreamingEncoder<XmlObject, RDF> {
    public Set<EncoderKey> getKeys() {
        return CodingHelper.encoderKeysForElements((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Class[])new Class[]{RDF.class});
    }

    public XmlObject encode(RDF rdf) throws EncodingException {
        return this.encode(rdf, EncodingContext.empty());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public XmlObject encode(RDF rdf, EncodingContext additionalValues) throws EncodingException {
        try (PipedInputStream pis = new PipedInputStream();){
            XmlObject xmlObject;
            try (PipedOutputStream pos = new PipedOutputStream();){
                pis.connect(pos);
                this.encode(rdf, pos);
                xmlObject = XmlObject.Factory.parse((InputStream)pis);
            }
            return xmlObject;
        }
        catch (Exception e) {
            throw new EncodingException("Error while encoding element!", (Throwable)e);
        }
    }

    public void encode(RDF rdf, OutputStream outputStream, EncodingContext context) throws EncodingException {
        try {
            new RdfStreamWriter(context, outputStream, rdf).write();
        }
        catch (XMLStreamException xmlse) {
            throw new EncodingException("Error while writing element to stream!", (Throwable)xmlse);
        }
    }

    public MediaType getContentType() {
        return MediaTypes.TEXT_XML;
    }
}

