/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.n52.shetland.ogc.ows.exception.CodedException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionCode;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.soap.AbstractSoap;
import org.n52.shetland.w3c.soap.SoapConstants;
import org.n52.shetland.w3c.soap.SoapFault;
import org.n52.shetland.w3c.soap.SoapHeader;
import org.n52.shetland.w3c.soap.SoapRequest;
import org.n52.shetland.w3c.soap.SoapResponse;
import org.n52.shetland.w3c.wsa.WsaActionHeader;
import org.n52.shetland.w3c.wsa.WsaHeader;
import org.n52.svalbard.encode.AbstractSoapEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.StreamingEncoder;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.N52XmlHelper;
import org.n52.svalbard.util.OwsHelper;
import org.n52.svalbard.write.Soap12XmlStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x2003.x05.soapEnvelope.Body;
import org.w3.x2003.x05.soapEnvelope.Envelope;
import org.w3.x2003.x05.soapEnvelope.EnvelopeDocument;
import org.w3.x2003.x05.soapEnvelope.Fault;
import org.w3.x2003.x05.soapEnvelope.FaultDocument;
import org.w3.x2003.x05.soapEnvelope.Faultcode;
import org.w3.x2003.x05.soapEnvelope.Reasontext;
import org.w3.x2003.x05.soapEnvelope.Subcode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Soap12Encoder
extends AbstractSoapEncoder<XmlObject, Object>
implements StreamingEncoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Soap12Encoder.class);
    private static final Set<EncoderKey> ENCODER_KEY_TYPES = CodingHelper.encoderKeysForElements((String)"http://www.w3.org/2003/05/soap-envelope", (Class[])new Class[]{SoapResponse.class, SoapRequest.class, SoapFault.class, OwsExceptionReport.class});

    public Soap12Encoder() {
        super("http://www.w3.org/2003/05/soap-envelope");
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEY_TYPES));
    }

    @Override
    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(CollectionHelper.union((Set[])new Set[]{ENCODER_KEY_TYPES, super.getKeys()}));
    }

    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException {
        if (element instanceof SoapResponse) {
            return this.createEnvelope((AbstractSoap<?>)((SoapResponse)element), additionalValues);
        }
        if (element instanceof SoapRequest) {
            return this.createEnvelope((AbstractSoap<?>)((SoapRequest)element), additionalValues);
        }
        if (element instanceof SoapFault) {
            return this.createFault((SoapFault)element);
        }
        if (element instanceof OwsExceptionReport) {
            return this.createFaultFromExceptionResponse((OwsExceptionReport)((Object)element));
        }
        throw new UnsupportedEncoderInputException((Encoder)this, element);
    }

    public void encode(Object element, OutputStream outputStream, EncodingContext ctx) throws EncodingException {
        if (element instanceof SoapResponse) {
            try {
                EncodingContext context = ctx.with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions);
                new Soap12XmlStreamWriter(context, outputStream, (SoapResponse)element).write();
            }
            catch (XMLStreamException ex) {
                throw new EncodingException((Throwable)ex);
            }
        }
        try {
            this.encode(element, ctx).save(outputStream, this.getXmlOptions());
        }
        catch (IOException ioe) {
            throw new EncodingException("Error while writing element to stream!", (Throwable)ioe);
        }
    }

    private XmlObject createEnvelope(AbstractSoap<?> soap, EncodingContext additionalValues) throws EncodingException {
        String action = null;
        EnvelopeDocument envelopeDoc = EnvelopeDocument.Factory.newInstance();
        Envelope envelope = envelopeDoc.addNewEnvelope();
        Body body = envelope.addNewBody();
        if (soap.getSoapFault() != null) {
            body.set(this.createFault(soap.getSoapFault()));
        } else if (soap instanceof SoapResponse && ((SoapResponse)soap).hasException()) {
            SoapResponse response = (SoapResponse)soap;
            if (!response.getException().getExceptions().isEmpty()) {
                CodedException firstException = (CodedException)response.getException().getExceptions().get(0);
                action = this.getExceptionActionURI(firstException.getCode());
            }
            body.set(this.createFaultFromExceptionResponse(response.getException()));
            N52XmlHelper.setSchemaLocationsToDocument((XmlObject)envelopeDoc, (Collection)Sets.newHashSet((Object[])new SchemaLocation[]{N52XmlHelper.getSchemaLocationForSOAP12(), N52XmlHelper.getSchemaLocationForOWS110Exception()}));
        } else {
            action = soap.getSoapAction();
            XmlObject bodyContent = this.getBodyContent(soap);
            String value = null;
            Node nodeToRemove = null;
            NamedNodeMap attributeMap = bodyContent.getDomNode().getFirstChild().getAttributes();
            for (int i = 0; i < attributeMap.getLength(); ++i) {
                Node node = attributeMap.item(i);
                if (!node.getLocalName().equals("schemaLocation")) continue;
                value = node.getNodeValue();
                nodeToRemove = node;
            }
            if (nodeToRemove != null) {
                attributeMap.removeNamedItem(nodeToRemove.getNodeName());
            }
            HashSet schemaLocations = Sets.newHashSet();
            schemaLocations.add(N52XmlHelper.getSchemaLocationForSOAP12());
            if (value != null && !value.isEmpty()) {
                String[] split = value.split(" ");
                for (int i = 0; i <= split.length - 2; i += 2) {
                    schemaLocations.add(new SchemaLocation(split[i], split[i + 1]));
                }
            }
            N52XmlHelper.setSchemaLocationsToDocument((XmlObject)envelopeDoc, (Collection)schemaLocations);
            body.set(bodyContent);
        }
        if (soap.getHeader() != null) {
            this.createHeader(envelope, soap.getHeader(), action);
        } else {
            envelope.addNewHeader();
        }
        return envelopeDoc;
    }

    private void createHeader(Envelope envelope, List<SoapHeader> headers, String action) throws EncodingException {
        Node headerDomNode = envelope.addNewHeader().getDomNode();
        for (SoapHeader header : headers) {
            XmlObject xmObject;
            if ("http://www.w3.org/2005/08/addressing".equals(header.getNamespace()) && header instanceof WsaActionHeader) {
                ((WsaHeader)header).setValue(action);
            }
            if ((xmObject = this.encodeObjectToXml(header.getNamespace(), header)) == null) continue;
            Node ownerDoc = headerDomNode.getOwnerDocument().importNode(xmObject.getDomNode().getFirstChild(), true);
            headerDomNode.insertBefore(ownerDoc, null);
        }
    }

    private XmlObject createFault(SoapFault soapFault) {
        FaultDocument faultDoc = FaultDocument.Factory.newInstance();
        Fault fault = faultDoc.addNewFault();
        fault.addNewCode().setValue(soapFault.getFaultCode());
        Reasontext addNewText = fault.addNewReason().addNewText();
        addNewText.setLang(soapFault.getLocale().getDisplayLanguage());
        addNewText.setStringValue(soapFault.getFaultReason());
        if (soapFault.getDetailText() != null) {
            XmlString xmlString = XmlString.Factory.newInstance();
            xmlString.setStringValue(soapFault.getDetailText());
            fault.addNewDetail().set((XmlObject)xmlString);
        }
        return faultDoc;
    }

    private XmlObject createFaultFromExceptionResponse(OwsExceptionReport owsExceptionReport) throws EncodingException {
        FaultDocument faultDoc = FaultDocument.Factory.newInstance();
        Fault fault = faultDoc.addNewFault();
        Faultcode code = fault.addNewCode();
        code.setValue(SoapConstants.SENDER_FAULT);
        if (!owsExceptionReport.getExceptions().isEmpty()) {
            CodedException firstException = (CodedException)owsExceptionReport.getExceptions().get(0);
            Subcode subcode = code.addNewSubcode();
            QName qName = firstException.getCode() != null ? OwsHelper.getQNameForLocalName(firstException.getCode().toString()) : OwsHelper.getQNameForLocalName(OwsExceptionCode.NoApplicableCode.name());
            subcode.setValue(qName);
            Reasontext addNewText = fault.addNewReason().addNewText();
            addNewText.setLang(Locale.ENGLISH.getLanguage());
            addNewText.setStringValue(this.getSoapFaultReasonText(firstException.getCode()));
            fault.addNewDetail().set(this.encodeObjectToXml("http://www.opengis.net/ows/1.1", firstException, EncodingContext.of((Enum)XmlBeansEncodingFlags.ENCODE_OWS_EXCEPTION_ONLY)));
        }
        return faultDoc;
    }
}

