/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.opengis.sos.x20.GetResultDocument;
import net.opengis.sos.x20.GetResultTemplateDocument;
import net.opengis.sos.x20.GetResultTemplateType;
import net.opengis.sos.x20.GetResultType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.request.GetResultRequest;
import org.n52.shetland.ogc.sos.request.GetResultTemplateRequest;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SosRequestEncoderv20
extends AbstractXmlEncoder<XmlObject, OwsServiceRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SosRequestEncoderv20.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/sos/2.0", (Class[])new Class[]{OwsServiceRequest.class, GetResultTemplateRequest.class, GetResultRequest.class}), CodingHelper.xmlEncoderKeysForOperationAndMediaType((String)"SOS", (String)"2.0.0", (Enum[])new Enum[]{Sos2Constants.Operations.GetResultTemplate})});

    public SosRequestEncoderv20() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/sos/2.0", "sos");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{Sos2Constants.SOS_SCHEMA_LOCATION});
    }

    @Override
    public XmlObject encode(OwsServiceRequest communicationObject) throws EncodingException {
        return this.encode(communicationObject, EncodingContext.empty());
    }

    public XmlObject encode(OwsServiceRequest request, EncodingContext additionalValues) throws EncodingException {
        XmlObject encodedObject = this.encodeRequests(request);
        XmlHelper.validateDocument((XmlObject)encodedObject, EncodingException::new);
        return encodedObject;
    }

    private XmlObject encodeRequests(OwsServiceRequest request) throws EncodingException {
        if (request instanceof GetResultTemplateRequest) {
            return this.createGetResultTemplateRequest((GetResultTemplateRequest)request);
        }
        if (request instanceof GetResultRequest) {
            return this.createGetResultRequest((GetResultRequest)request);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)request);
    }

    private XmlObject createGetResultTemplateRequest(GetResultTemplateRequest request) {
        GetResultTemplateDocument getResultTemplateDoc = GetResultTemplateDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        GetResultTemplateType getResultTemplate = getResultTemplateDoc.addNewGetResultTemplate();
        getResultTemplate.setService(request.getService());
        getResultTemplate.setVersion(request.getVersion());
        getResultTemplate.setOffering(request.getOffering());
        getResultTemplate.setObservedProperty(request.getObservedProperty());
        return getResultTemplateDoc;
    }

    private XmlObject createGetResultRequest(GetResultRequest request) throws EncodingException {
        GetResultDocument getResultDoc = GetResultDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        GetResultType getResult = getResultDoc.addNewGetResult();
        getResult.setService(request.getService());
        getResult.setVersion(request.getVersion());
        getResult.setOffering(request.getOffering());
        getResult.setObservedProperty(request.getObservedProperty());
        if (request.isSetFeatureOfInterest()) {
            request.getFeatureIdentifiers().forEach(arg_0 -> ((GetResultType)getResult).addFeatureOfInterest(arg_0));
        }
        if (request.hasTemporalFilter()) {
            for (TemporalFilter temporalFilter : request.getTemporalFilter()) {
                this.createTemporalFilter(getResult.addNewTemporalFilter(), temporalFilter);
            }
        }
        if (request.isSetSpatialFilter()) {
            this.createSpatialFilter(getResult.addNewSpatialFilter(), request.getSpatialFilter());
        }
        return getResultDoc;
    }

    private void createTemporalFilter(GetResultType.TemporalFilter temporalFilter, TemporalFilter sosTemporalFilter) throws EncodingException {
        Encoder<XmlObject, TemporalFilter> encoder = this.getEncoder("http://www.opengis.net/fes/2.0", sosTemporalFilter);
        XmlObject encodedObject = (XmlObject)encoder.encode((Object)sosTemporalFilter);
        temporalFilter.set(encodedObject);
    }

    private void createSpatialFilter(GetResultType.SpatialFilter spatialFilter, SpatialFilter sosSpatialFilter) throws EncodingException {
        Encoder<XmlObject, SpatialFilter> encoder = this.getEncoder("http://www.opengis.net/fes/2.0", sosSpatialFilter);
        XmlObject encodedObject = (XmlObject)encoder.encode((Object)sosSpatialFilter);
        spatialFilter.set(encodedObject);
    }
}

