/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.w3c.wsa.WsaActionHeader;
import org.n52.shetland.w3c.wsa.WsaHeader;
import org.n52.shetland.w3c.wsa.WsaMessageIDHeader;
import org.n52.shetland.w3c.wsa.WsaRelatesToHeader;
import org.n52.shetland.w3c.wsa.WsaReplyToHeader;
import org.n52.shetland.w3c.wsa.WsaToHeader;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x2005.x08.addressing.ActionDocument;
import org.w3.x2005.x08.addressing.MessageIDDocument;
import org.w3.x2005.x08.addressing.RelatesToDocument;
import org.w3.x2005.x08.addressing.ReplyToDocument;
import org.w3.x2005.x08.addressing.ToDocument;

public class WsaEncoder
extends AbstractXmlEncoder<XmlObject, WsaHeader> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WsaEncoder.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://www.w3.org/2005/08/addressing", (Class[])new Class[]{WsaHeader.class});

    public WsaEncoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    public MediaType getContentType() {
        return MediaTypes.TEXT_XML;
    }

    @Override
    public XmlObject encode(WsaHeader wsaHeader) throws EncodingException {
        return this.encode(wsaHeader, EncodingContext.empty());
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public XmlObject encode(WsaHeader wsaHeader, EncodingContext additionalValues) throws EncodingException {
        if (wsaHeader == null) {
            throw new UnsupportedEncoderInputException((Encoder)this, (Object)wsaHeader);
        }
        if (!wsaHeader.isSetValue()) {
            return null;
        }
        if (wsaHeader instanceof WsaReplyToHeader) {
            return this.encodeReplyToHeader((WsaReplyToHeader)wsaHeader);
        }
        if (wsaHeader instanceof WsaMessageIDHeader) {
            return this.encodeMessageIDHeader((WsaMessageIDHeader)wsaHeader);
        }
        if (wsaHeader instanceof WsaActionHeader) {
            return this.encodeActionHeader((WsaActionHeader)wsaHeader);
        }
        if (wsaHeader instanceof WsaToHeader) {
            return this.encodeToHeader((WsaToHeader)wsaHeader);
        }
        if (wsaHeader instanceof WsaRelatesToHeader) {
            return this.encodeRelatesToHeader((WsaRelatesToHeader)wsaHeader);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)wsaHeader);
    }

    private XmlObject encodeReplyToHeader(WsaReplyToHeader wsaHeader) {
        ReplyToDocument replyToDoc = ReplyToDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        replyToDoc.addNewReplyTo().addNewAddress().setStringValue(wsaHeader.getValue());
        return replyToDoc;
    }

    private XmlObject encodeRelatesToHeader(WsaRelatesToHeader wsaHeader) {
        RelatesToDocument relatesToDoc = RelatesToDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        relatesToDoc.addNewRelatesTo().setStringValue(wsaHeader.getValue());
        return relatesToDoc;
    }

    private XmlObject encodeMessageIDHeader(WsaMessageIDHeader wsaHeader) {
        MessageIDDocument messageIDDoc = MessageIDDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        messageIDDoc.addNewMessageID().setStringValue(wsaHeader.getValue());
        return null;
    }

    private XmlObject encodeActionHeader(WsaActionHeader wsaHeader) {
        ActionDocument actionDoc = ActionDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        actionDoc.addNewAction().setStringValue(wsaHeader.getValue());
        return actionDoc;
    }

    private XmlObject encodeToHeader(WsaToHeader wsaHeader) {
        ToDocument toDoc = ToDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        toDoc.addNewTo().setStringValue(wsaHeader.getValue());
        return toDoc;
    }
}

