/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.opengis.ows.x11.AddressType;
import net.opengis.ows.x11.AllowedValuesDocument;
import net.opengis.ows.x11.AnyValueDocument;
import net.opengis.ows.x11.CapabilitiesBaseType;
import net.opengis.ows.x11.CodeType;
import net.opengis.ows.x11.ContactType;
import net.opengis.ows.x11.DCPDocument;
import net.opengis.ows.x11.DomainMetadataType;
import net.opengis.ows.x11.DomainType;
import net.opengis.ows.x11.HTTPDocument;
import net.opengis.ows.x11.KeywordsType;
import net.opengis.ows.x11.LanguageStringType;
import net.opengis.ows.x11.MetadataType;
import net.opengis.ows.x11.NoValuesDocument;
import net.opengis.ows.x11.OnlineResourceType;
import net.opengis.ows.x11.OperationDocument;
import net.opengis.ows.x11.OperationsMetadataDocument;
import net.opengis.ows.x11.RangeType;
import net.opengis.ows.x11.RequestMethodType;
import net.opengis.ows.x11.ResponsiblePartySubsetType;
import net.opengis.ows.x11.ServiceIdentificationDocument;
import net.opengis.ows.x11.ServiceProviderDocument;
import net.opengis.ows.x11.TelephoneType;
import net.opengis.ows.x11.ValueType;
import net.opengis.ows.x11.ValuesReferenceDocument;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.i18n.LocaleHelper;
import org.n52.janmayen.i18n.LocalizedString;
import org.n52.janmayen.i18n.MultilingualString;
import org.n52.shetland.ogc.ows.OwsAddress;
import org.n52.shetland.ogc.ows.OwsAllowedValues;
import org.n52.shetland.ogc.ows.OwsAnyValue;
import org.n52.shetland.ogc.ows.OwsCapabilities;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.ows.OwsContact;
import org.n52.shetland.ogc.ows.OwsDCP;
import org.n52.shetland.ogc.ows.OwsDomain;
import org.n52.shetland.ogc.ows.OwsDomainMetadata;
import org.n52.shetland.ogc.ows.OwsHttp;
import org.n52.shetland.ogc.ows.OwsKeyword;
import org.n52.shetland.ogc.ows.OwsLanguageString;
import org.n52.shetland.ogc.ows.OwsMetadata;
import org.n52.shetland.ogc.ows.OwsNoValues;
import org.n52.shetland.ogc.ows.OwsOnlineResource;
import org.n52.shetland.ogc.ows.OwsOperation;
import org.n52.shetland.ogc.ows.OwsOperationMetadataExtension;
import org.n52.shetland.ogc.ows.OwsOperationsMetadata;
import org.n52.shetland.ogc.ows.OwsPhone;
import org.n52.shetland.ogc.ows.OwsPossibleValues;
import org.n52.shetland.ogc.ows.OwsRange;
import org.n52.shetland.ogc.ows.OwsReferenceSystem;
import org.n52.shetland.ogc.ows.OwsRequestMethod;
import org.n52.shetland.ogc.ows.OwsResponsibleParty;
import org.n52.shetland.ogc.ows.OwsServiceIdentification;
import org.n52.shetland.ogc.ows.OwsServiceProvider;
import org.n52.shetland.ogc.ows.OwsUOM;
import org.n52.shetland.ogc.ows.OwsValue;
import org.n52.shetland.ogc.ows.OwsValuesReference;
import org.n52.shetland.ogc.ows.OwsValuesUnit;
import org.n52.shetland.w3c.xlink.Actuate;
import org.n52.shetland.w3c.xlink.Show;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.exception.DecodingException;

public abstract class AbstractCapabilitiesBaseTypeDecoder<T, S>
extends AbstractXmlDecoder<T, S> {
    protected OwsCapabilities parseCapabilitiesBaseType(String service, CapabilitiesBaseType cbt) throws DecodingException {
        if (cbt == null) {
            return null;
        }
        OwsServiceIdentification serviceIdentification = this.parseServiceIdentification(cbt.getServiceIdentification());
        OwsServiceProvider serviceProvider = this.parseServiceProvider(cbt.getServiceProvider());
        OwsOperationsMetadata operationsMetadata = this.parseOperationMetadata(cbt.getOperationsMetadata());
        Collection languages = null;
        Collection extensions = null;
        return new OwsCapabilities(service, cbt.getVersion(), cbt.getUpdateSequence(), serviceIdentification, serviceProvider, operationsMetadata, languages, extensions);
    }

    private List<OwsOperation> parseOperations(OperationDocument.Operation[] operations) {
        return Optional.ofNullable(operations).map(Arrays::stream).orElseGet(Stream::empty).map(this::parseOperation).collect(Collectors.toList());
    }

    private OwsOperation parseOperation(OperationDocument.Operation operation) {
        if (operation == null) {
            return null;
        }
        List<OwsDomain> parameters = this.parseDomains(operation.getParameterArray());
        List<OwsDomain> constraints = this.parseDomains(operation.getConstraintArray());
        Set<OwsMetadata> metadata = this.parseMetadata(operation.getMetadataArray());
        List<OwsDCP> dcps = this.parseDCPs(operation.getDCPArray());
        return new OwsOperation(operation.getName(), parameters, constraints, metadata, dcps);
    }

    private OwsValue parseValue(ValueType value) {
        if (value == null) {
            return null;
        }
        return new OwsValue(value.getStringValue());
    }

    private OwsRange parseRange(RangeType range) {
        if (range == null) {
            return null;
        }
        OwsValue upperBound = this.parseValue(range.getMaximumValue());
        OwsValue lowerBound = this.parseValue(range.getMinimumValue());
        OwsValue spacing = this.parseValue(range.getSpacing());
        String type = null;
        if (range.isSetRangeClosure() && !range.getRangeClosure().isEmpty()) {
            type = (String)range.getRangeClosure().get(0);
        }
        return new OwsRange(lowerBound, upperBound, type, spacing);
    }

    private <T extends OwsDomainMetadata> T parse(BiFunction<URI, String, T> fun, DomainMetadataType metadata) {
        if (metadata == null) {
            return null;
        }
        URI reference = Optional.ofNullable(metadata.getReference()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        String value = metadata.getStringValue();
        return (T)((OwsDomainMetadata)fun.apply(reference, value));
    }

    private OwsDomainMetadata parseDomainMetadata(DomainMetadataType metadata) {
        return this.parse(OwsDomainMetadata::new, metadata);
    }

    private OwsMetadata parseMetadata(MetadataType metadata) {
        if (metadata == null) {
            return null;
        }
        URI href = Optional.ofNullable(metadata.getHref()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        URI role = Optional.ofNullable(metadata.getRole()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        URI arcrole = Optional.ofNullable(metadata.getArcrole()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        Show show = Optional.ofNullable(metadata.getShow()).map(Object::toString).map(Show::valueOf).orElse(null);
        Actuate actuate = Optional.ofNullable(metadata.getActuate()).map(Object::toString).map(Actuate::valueOf).orElse(null);
        URI about = Optional.ofNullable(metadata.getAbout()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        String title = metadata.getTitle();
        return new OwsMetadata(href, role, arcrole, title, show, actuate, about);
    }

    private Set<OwsMetadata> parseMetadata(MetadataType[] metadata) {
        return Optional.ofNullable(metadata).map(Arrays::stream).orElseGet(Stream::empty).map(this::parseMetadata).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private OwsUOM parseUom(DomainMetadataType uom) {
        return this.parse(OwsUOM::new, uom);
    }

    private OwsReferenceSystem parseReferenceSystem(DomainMetadataType uom) {
        return this.parse(OwsReferenceSystem::new, uom);
    }

    private OwsNoValues parseNoValues(NoValuesDocument.NoValues noValues) {
        if (noValues == null) {
            return null;
        }
        return OwsNoValues.instance();
    }

    private OwsAnyValue parseAnyValue(AnyValueDocument.AnyValue anyValue) {
        if (anyValue == null) {
            return null;
        }
        return OwsAnyValue.instance();
    }

    private OwsValuesReference parseValuesReference(ValuesReferenceDocument.ValuesReference valuesReference) {
        if (valuesReference == null) {
            return null;
        }
        URI reference = Optional.ofNullable(valuesReference.getReference()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        String value = valuesReference.getStringValue();
        return new OwsValuesReference(reference, value);
    }

    private OwsAllowedValues parseAllowedValues(AllowedValuesDocument.AllowedValues allowedValues) {
        if (allowedValues == null) {
            return null;
        }
        return new OwsAllowedValues(Stream.concat(Optional.ofNullable(allowedValues.getValueArray()).map(Arrays::stream).orElseGet(Stream::empty).map(this::parseValue), Optional.ofNullable(allowedValues.getRangeArray()).map(Arrays::stream).orElseGet(Stream::empty).map(this::parseRange)).filter(Objects::nonNull));
    }

    private OwsDomain parseDomain(DomainType domain) {
        if (domain == null) {
            return null;
        }
        OwsValue defaultValue = this.parseValue(domain.getDefaultValue());
        Set<OwsMetadata> metadata = this.parseMetadata(domain.getMetadataArray());
        OwsDomainMetadata meaning = this.parseDomainMetadata(domain.getMeaning());
        OwsDomainMetadata dataType = this.parseDomainMetadata(domain.getDataType());
        OwsValuesUnit valuesUnit = Stream.of(this.parseUom(domain.getUOM()), this.parseReferenceSystem(domain.getReferenceSystem())).filter(Objects::nonNull).findFirst().orElse(null);
        OwsPossibleValues possibleValues = Stream.of(this.parseAnyValue(domain.getAnyValue()), this.parseAllowedValues(domain.getAllowedValues()), this.parseValuesReference(domain.getValuesReference()), this.parseNoValues(domain.getNoValues())).filter(Objects::nonNull).findFirst().orElse(null);
        return new OwsDomain(domain.getName(), possibleValues, defaultValue, meaning, dataType, valuesUnit, metadata);
    }

    private List<OwsDomain> parseDomains(DomainType[] domains) {
        return Optional.ofNullable(domains).map(Arrays::stream).orElseGet(Stream::empty).map(this::parseDomain).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<OwsDCP> parseDCPs(DCPDocument.DCP[] dcps) {
        return Optional.ofNullable(dcps).map(Arrays::stream).orElseGet(Stream::empty).map(this::parseDCP).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private OwsDCP parseDCP(DCPDocument.DCP dcp) {
        if (dcp == null) {
            return null;
        }
        return this.parseHTTP(dcp.getHTTP());
    }

    private OwsDCP parseHTTP(HTTPDocument.HTTP http) {
        if (http == null) {
            return null;
        }
        return new OwsHttp((Collection)Stream.concat(Optional.ofNullable(http.getGetArray()).map(Arrays::stream).orElseGet(Stream::empty).map(this::parseGetRequestMethod), Optional.ofNullable(http.getPostArray()).map(Arrays::stream).orElseGet(Stream::empty).map(this::parsePostRequestMethod)).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private OwsRequestMethod parseGetRequestMethod(RequestMethodType method) {
        return this.parseRequestMethod("GET", method);
    }

    private OwsRequestMethod parsePostRequestMethod(RequestMethodType method) {
        return this.parseRequestMethod("POST", method);
    }

    private OwsRequestMethod parseRequestMethod(String httpMethod, RequestMethodType method) {
        if (method == null) {
            return null;
        }
        URI href = Optional.ofNullable(method.getHref()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        URI role = Optional.ofNullable(method.getRole()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        URI arcrole = Optional.ofNullable(method.getArcrole()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        Show show = Optional.ofNullable(method.getShow()).map(Object::toString).map(Show::valueOf).orElse(null);
        Actuate actuate = Optional.ofNullable(method.getActuate()).map(Object::toString).map(Actuate::valueOf).orElse(null);
        String title = method.getTitle();
        List<OwsDomain> constraints = this.parseDomains(method.getConstraintArray());
        return new OwsRequestMethod(href, constraints, httpMethod, role, arcrole, title, show, actuate);
    }

    private OwsOperationsMetadata parseOperationMetadata(OperationsMetadataDocument.OperationsMetadata operationsMetadata) {
        if (operationsMetadata == null) {
            return null;
        }
        List<OwsOperation> operations = this.parseOperations(operationsMetadata.getOperationArray());
        List<OwsDomain> parameters = this.parseDomains(operationsMetadata.getParameterArray());
        List<OwsDomain> constraints = this.parseDomains(operationsMetadata.getConstraintArray());
        OwsOperationMetadataExtension extension = this.parseOperationsMetadataExtension(operationsMetadata.getExtendedCapabilities());
        return new OwsOperationsMetadata(operations, parameters, constraints, extension);
    }

    private OwsServiceIdentification parseServiceIdentification(ServiceIdentificationDocument.ServiceIdentification serviceIdentification) {
        if (serviceIdentification == null) {
            return null;
        }
        OwsCode serviceType = this.parseCode(serviceIdentification.getServiceType());
        Set serviceTypeVersion = Optional.ofNullable(serviceIdentification.getServiceTypeVersionArray()).map(Arrays::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
        Set fees = Optional.ofNullable(serviceIdentification.getFees()).map(Collections::singleton).orElseGet(Collections::emptySet);
        Set profiles = Optional.ofNullable(serviceIdentification.getProfileArray()).map(Arrays::stream).orElseGet(Stream::empty).map(URI::create).collect(Collectors.toSet());
        Set accessConstraints = Optional.ofNullable(serviceIdentification.getAccessConstraintsArray()).map(Arrays::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
        MultilingualString title = new MultilingualString();
        MultilingualString abstrakt = new MultilingualString();
        Optional.ofNullable(serviceIdentification.getTitleArray()).map(Arrays::stream).orElseGet(Stream::empty).map(this::parseLanguageString).forEach(arg_0 -> ((MultilingualString)title).addLocalization(arg_0));
        Optional.ofNullable(serviceIdentification.getAbstractArray()).map(Arrays::stream).orElseGet(Stream::empty).map(this::parseLanguageString).forEach(arg_0 -> ((MultilingualString)abstrakt).addLocalization(arg_0));
        Set keywords = Optional.ofNullable(serviceIdentification.getKeywordsArray()).map(Arrays::stream).orElseGet(Stream::empty).flatMap(this::parseKeyword).filter(Objects::nonNull).collect(Collectors.toSet());
        return new OwsServiceIdentification(serviceType, serviceTypeVersion, profiles, fees, accessConstraints, title, abstrakt, keywords);
    }

    private Stream<OwsKeyword> parseKeyword(KeywordsType keyword) {
        if (keyword == null) {
            return Stream.empty();
        }
        OwsCode type = this.parseCode(keyword.getType());
        return Arrays.stream(keyword.getKeywordArray()).map(ls -> new OwsLanguageString(ls.getLang(), ls.getStringValue())).map(ls -> new OwsKeyword(ls, type));
    }

    private OwsServiceProvider parseServiceProvider(ServiceProviderDocument.ServiceProvider serviceProvider) {
        if (serviceProvider == null) {
            return null;
        }
        OwsOnlineResource providerSite = this.parseOnlineResource(serviceProvider.getProviderSite());
        OwsResponsibleParty serviceContact = this.parseResponsibleParty(serviceProvider.getServiceContact());
        String providerName = serviceProvider.getProviderName();
        return new OwsServiceProvider(providerName, providerSite, serviceContact);
    }

    private OwsOnlineResource parseOnlineResource(OnlineResourceType onlineResource) {
        if (onlineResource == null) {
            return null;
        }
        URI href = Optional.ofNullable(onlineResource.getHref()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        URI role = Optional.ofNullable(onlineResource.getRole()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        URI arcrole = Optional.ofNullable(onlineResource.getArcrole()).map(Strings::emptyToNull).map(URI::create).orElse(null);
        Show show = Optional.ofNullable(onlineResource.getShow()).map(Object::toString).map(Show::valueOf).orElse(null);
        Actuate actuate = Optional.ofNullable(onlineResource.getActuate()).map(Object::toString).map(Actuate::valueOf).orElse(null);
        String title = onlineResource.getTitle();
        return new OwsOnlineResource(href, role, arcrole, title, show, actuate);
    }

    private OwsResponsibleParty parseResponsibleParty(ResponsiblePartySubsetType responsibleParty) {
        if (responsibleParty == null) {
            return null;
        }
        String positionName = responsibleParty.getPositionName();
        String individualName = responsibleParty.getIndividualName();
        String organisationName = null;
        OwsContact contactInfo = this.parseContact(responsibleParty.getContactInfo());
        OwsCode role = this.parseCode(responsibleParty.getRole());
        return new OwsResponsibleParty(individualName, organisationName, positionName, contactInfo, role);
    }

    private OwsContact parseContact(ContactType contactInfo) {
        if (contactInfo == null) {
            return null;
        }
        OwsOnlineResource onlineResource = this.parseOnlineResource(contactInfo.getOnlineResource());
        String hoursOfService = contactInfo.getHoursOfService();
        String contactInstructions = contactInfo.getContactInstructions();
        OwsAddress address = this.parseAddress(contactInfo.getAddress());
        OwsPhone phone = this.parsePhone(contactInfo.getPhone());
        return new OwsContact(phone, address, onlineResource, hoursOfService, contactInstructions);
    }

    private OwsCode parseCode(CodeType code) {
        if (code == null || Strings.isNullOrEmpty((String)code.getStringValue())) {
            return null;
        }
        return new OwsCode(code.getStringValue(), (URI)Optional.ofNullable(code.getCodeSpace()).map(Strings::emptyToNull).map(URI::create).orElse(null));
    }

    private OwsPhone parsePhone(TelephoneType phone) {
        if (phone == null) {
            return null;
        }
        Set voice = Optional.ofNullable(phone.getVoiceArray()).map(Arrays::stream).orElseGet(Stream::empty).map(Strings::emptyToNull).filter(Objects::nonNull).collect(Collectors.toSet());
        Set facsimile = Optional.ofNullable(phone.getFacsimileArray()).map(Arrays::stream).orElseGet(Stream::empty).map(Strings::emptyToNull).filter(Objects::nonNull).collect(Collectors.toSet());
        return new OwsPhone(voice, facsimile);
    }

    private OwsAddress parseAddress(AddressType address) {
        if (address == null) {
            return null;
        }
        List deliveryPoint = Optional.ofNullable(address.getDeliveryPointArray()).map(Arrays::stream).orElseGet(Stream::empty).map(Strings::emptyToNull).filter(Objects::nonNull).collect(Collectors.toList());
        List electronicMailAddress = Optional.ofNullable(address.getElectronicMailAddressArray()).map(Arrays::stream).orElseGet(Stream::empty).map(Strings::emptyToNull).filter(Objects::nonNull).collect(Collectors.toList());
        String city = address.getCity();
        String administrativeArea = address.getAdministrativeArea();
        String postalCode = address.getPostalCode();
        String country = address.getCountry();
        return new OwsAddress(deliveryPoint, city, administrativeArea, postalCode, country, electronicMailAddress);
    }

    private OwsOperationMetadataExtension parseOperationsMetadataExtension(XmlObject extendedCapabilities) {
        return null;
    }

    private LocalizedString parseLanguageString(LanguageStringType lst) {
        if (lst.getLang() == null) {
            return new LocalizedString(null, lst.getStringValue());
        }
        return new LocalizedString(LocaleHelper.decode((String)lst.getLang()), lst.getStringValue());
    }
}

