/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import net.opengis.sos.x10.DescribeSensorDocument;
import net.opengis.sos.x10.GetCapabilitiesDocument;
import net.opengis.sos.x10.GetFeatureOfInterestDocument;
import net.opengis.sos.x10.GetObservationByIdDocument;
import net.opengis.sos.x10.GetObservationDocument;
import net.opengis.sos.x10.ResponseModeType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.ogc.filter.ComparisonFilter;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.om.OmConstants;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.request.DescribeSensorRequest;
import org.n52.shetland.ogc.sos.request.GetFeatureOfInterestRequest;
import org.n52.shetland.ogc.sos.request.GetObservationByIdRequest;
import org.n52.shetland.ogc.sos.request.GetObservationRequest;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.util.OMHelper;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SosDecoderv100
extends AbstractXmlDecoder<XmlObject, OwsServiceCommunicationObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SosDecoderv100.class);
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sos/1.0", (Class[])new Class[]{GetCapabilitiesDocument.class, DescribeSensorDocument.class, GetObservationDocument.class, GetFeatureOfInterestDocument.class, GetObservationByIdDocument.class}), CodingHelper.xmlDecoderKeysForOperation((String)"SOS", (String)"1.0.0", (Enum[])new Enum[]{SosConstants.Operations.GetCapabilities, SosConstants.Operations.GetObservation, SosConstants.Operations.GetFeatureOfInterest, SosConstants.Operations.GetObservationById, SosConstants.Operations.DescribeSensor})});

    public SosDecoderv100() {
        LOGGER.debug("Decoder for the following namespaces initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public OwsServiceCommunicationObject decode(XmlObject xmlObject) throws DecodingException {
        OwsServiceRequest request = null;
        LOGGER.debug("REQUESTTYPE:" + xmlObject.getClass());
        if (xmlObject instanceof GetObservationDocument) {
            XmlCursor cursor = xmlObject.newCursor();
            cursor.toFirstChild();
            cursor.insertNamespace("om", "http://www.opengis.net/om/1.0");
            cursor.dispose();
        }
        XmlHelper.validateDocument((XmlObject)xmlObject);
        if (xmlObject instanceof GetCapabilitiesDocument) {
            GetCapabilitiesDocument getCapsDoc = (GetCapabilitiesDocument)xmlObject;
            request = this.parseGetCapabilities(getCapsDoc);
        } else if (xmlObject instanceof DescribeSensorDocument) {
            DescribeSensorDocument descSensorDoc = (DescribeSensorDocument)xmlObject;
            request = this.parseDescribeSensor(descSensorDoc);
        } else if (xmlObject instanceof GetObservationDocument) {
            GetObservationDocument getObsDoc = (GetObservationDocument)xmlObject;
            request = this.parseGetObservation(getObsDoc);
        } else if (xmlObject instanceof GetFeatureOfInterestDocument) {
            GetFeatureOfInterestDocument getFoiDoc = (GetFeatureOfInterestDocument)xmlObject;
            request = this.parseGetFeatureOfInterest(getFoiDoc);
        } else if (xmlObject instanceof GetObservationByIdDocument) {
            GetObservationByIdDocument getObsByIdDoc = (GetObservationByIdDocument)xmlObject;
            request = this.parseGetObservationById(getObsByIdDoc);
        } else {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, xmlObject);
        }
        return request;
    }

    private OwsServiceRequest parseGetCapabilities(GetCapabilitiesDocument getCapsDoc) {
        GetCapabilitiesDocument.GetCapabilities getCaps = getCapsDoc.getGetCapabilities();
        GetCapabilitiesRequest request = new GetCapabilitiesRequest(getCaps.getService());
        if (getCaps.getAcceptFormats() != null && getCaps.getAcceptFormats().sizeOfOutputFormatArray() != 0) {
            request.setAcceptFormats(Arrays.asList(getCaps.getAcceptFormats().getOutputFormatArray()));
        }
        if (getCaps.getAcceptVersions() != null && getCaps.getAcceptVersions().sizeOfVersionArray() != 0) {
            request.setAcceptVersions(Arrays.asList(getCaps.getAcceptVersions().getVersionArray()));
        }
        if (getCaps.getSections() != null && getCaps.getSections().getSectionArray().length != 0) {
            request.setSections(Arrays.asList(getCaps.getSections().getSectionArray()));
        }
        return request;
    }

    private OwsServiceCommunicationObject parseDescribeSensor(DescribeSensorDocument descSensorDoc) {
        DescribeSensorRequest request = new DescribeSensorRequest();
        DescribeSensorDocument.DescribeSensor descSensor = descSensorDoc.getDescribeSensor();
        request.setService(descSensor.getService());
        request.setVersion(descSensor.getVersion());
        request.setProcedureDescriptionFormat(MediaType.normalizeString((String)descSensor.getOutputFormat()));
        request.setProcedure(descSensor.getProcedure());
        return request;
    }

    private OwsServiceRequest parseGetObservation(GetObservationDocument getObsDoc) throws DecodingException {
        GetObservationRequest getObsRequest = new GetObservationRequest();
        GetObservationDocument.GetObservation getObs = getObsDoc.getGetObservation();
        getObsRequest.setService(getObs.getService());
        getObsRequest.setVersion(getObs.getVersion());
        getObsRequest.setOfferings(Arrays.asList(getObs.getOffering()));
        getObsRequest.setObservedProperties(Arrays.asList(getObs.getObservedPropertyArray()));
        getObsRequest.setProcedures(Arrays.asList(getObs.getProcedureArray()));
        getObsRequest.setTemporalFilters(this.parseTemporalFilters4GetObservation(getObs.getEventTimeArray()));
        getObsRequest.setSrsName(getObs.getSrsName());
        if (getObs.isSetFeatureOfInterest()) {
            GetObservationDocument.GetObservation.FeatureOfInterest featureOfInterest = getObs.getFeatureOfInterest();
            if (featureOfInterest.isSetSpatialOps()) {
                Object filter = this.decodeXmlElement((XmlObject)featureOfInterest.getSpatialOps());
                if (filter instanceof SpatialFilter) {
                    getObsRequest.setSpatialFilter((SpatialFilter)filter);
                }
            } else if (featureOfInterest.getObjectIDArray() != null) {
                HashSet featureIdentifiers = Sets.newHashSet();
                for (String string : featureOfInterest.getObjectIDArray()) {
                    featureIdentifiers.add(string);
                }
                getObsRequest.setFeatureIdentifiers((List)Lists.newArrayList((Iterable)featureIdentifiers));
            }
        }
        if (getObs.isSetResult()) {
            getObsRequest.setResultFilter(this.parseResultFilter(getObs.getResult()));
        }
        if (getObs.isSetResponseFormat()) {
            getObsRequest.setResponseFormat(this.decodeResponseFormat(getObs.getResponseFormat()));
        } else {
            getObsRequest.setResponseFormat(OmConstants.CONTENT_TYPE_OM.toString());
        }
        if (getObs.isSetResultModel()) {
            getObsRequest.setResultModel(OMHelper.getObservationTypeFor((QName)getObs.getResultModel()));
        }
        return getObsRequest;
    }

    private OwsServiceRequest parseGetFeatureOfInterest(GetFeatureOfInterestDocument getFoiDoc) throws DecodingException {
        GetFeatureOfInterestRequest getFoiRequest = new GetFeatureOfInterestRequest();
        GetFeatureOfInterestDocument.GetFeatureOfInterest getFoi = getFoiDoc.getGetFeatureOfInterest();
        getFoiRequest.setService(getFoi.getService());
        getFoiRequest.setVersion(getFoi.getVersion());
        getFoiRequest.setFeatureIdentifiers(Arrays.asList(getFoi.getFeatureOfInterestIdArray()));
        getFoiRequest.setSpatialFilters(this.parseSpatialFilters4GetFeatureOfInterest(getFoi.getLocation()));
        return getFoiRequest;
    }

    private OwsServiceRequest parseGetObservationById(GetObservationByIdDocument getObsByIdDoc) throws DecodingException {
        GetObservationByIdRequest getObsByIdRequest = new GetObservationByIdRequest();
        GetObservationByIdDocument.GetObservationById getObsById = getObsByIdDoc.getGetObservationById();
        getObsByIdRequest.setService(getObsById.getService());
        getObsByIdRequest.setVersion(getObsById.getVersion());
        if (getObsById.isSetResponseFormat()) {
            getObsByIdRequest.setResponseFormat(this.decodeResponseFormat(getObsById.getResponseFormat()));
        } else {
            getObsByIdRequest.setResponseFormat(OmConstants.CONTENT_TYPE_OM.toString());
        }
        ResponseModeType.Enum responseMode = getObsById.getResponseMode();
        if (responseMode != null && responseMode.toString().equalsIgnoreCase("inline")) {
            getObsByIdRequest.setResponseMode("inline");
        }
        if (getObsById.isSetResultModel()) {
            getObsByIdRequest.setResultModel(OMHelper.getObservationTypeFor((QName)getObsById.getResultModel()));
        }
        getObsByIdRequest.setObservationIdentifier(Arrays.asList(getObsById.getObservationId()));
        return getObsByIdRequest;
    }

    private List<SpatialFilter> parseSpatialFilters4GetFeatureOfInterest(GetFeatureOfInterestDocument.GetFeatureOfInterest.Location location) throws DecodingException {
        Object filter;
        LinkedList<SpatialFilter> sosSpatialFilters = new LinkedList<SpatialFilter>();
        if (location != null && location.getSpatialOps() != null && (filter = this.decodeXmlElement((XmlObject)location.getSpatialOps())) instanceof SpatialFilter) {
            sosSpatialFilters.add((SpatialFilter)filter);
        }
        return sosSpatialFilters;
    }

    private List<TemporalFilter> parseTemporalFilters4GetObservation(GetObservationDocument.GetObservation.EventTime[] temporalFilters) throws DecodingException {
        LinkedList<TemporalFilter> sosTemporalFilters = new LinkedList<TemporalFilter>();
        for (GetObservationDocument.GetObservation.EventTime temporalFilter : temporalFilters) {
            Object filter = this.decodeXmlElement((XmlObject)temporalFilter.getTemporalOps());
            if (!(filter instanceof TemporalFilter)) continue;
            sosTemporalFilters.add((TemporalFilter)filter);
        }
        return sosTemporalFilters;
    }

    private ComparisonFilter parseResultFilter(GetObservationDocument.GetObservation.Result result) throws DecodingException {
        Object decodeXmlElement;
        if (result != null && result.getComparisonOps() != null && (decodeXmlElement = this.decodeXmlElement((XmlObject)result.getComparisonOps())) instanceof ComparisonFilter) {
            return (ComparisonFilter)decodeXmlElement;
        }
        return null;
    }

    private String decodeResponseFormat(String responseFormat) throws DecodingException {
        try {
            return MediaType.normalizeString((String)URLDecoder.decode(responseFormat, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new DecodingException("Error while decoding response format!", (Throwable)e);
        }
    }
}

