/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.exception.ExceptionCode;
import org.n52.shetland.ogc.ows.exception.OwsExceptionCode;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.sos.exception.SosExceptionCode;
import org.n52.shetland.ogc.swes.exception.SwesExceptionCode;
import org.n52.shetland.w3c.soap.AbstractSoap;
import org.n52.shetland.w3c.soap.SoapRequest;
import org.n52.shetland.w3c.soap.SoapResponse;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.OperationRequestEncoderKey;
import org.n52.svalbard.encode.OperationResponseEncoderKey;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;

public abstract class AbstractSoapEncoder<T, S>
extends AbstractXmlEncoder<T, S> {
    public static final String DEFAULT_FAULT_REASON = "A server exception was encountered.";
    public static final String MISSING_RESPONSE_DETAIL_TEXT = "Missing SOS response document!";
    public static final String MISSING_EXCEPTION_DETAIL_TEXT = "Error while creating SOAPFault element from OWSException! OWSException is missing!";
    private final Set<EncoderKey> encoderKey;

    public AbstractSoapEncoder(String namespace) {
        this.encoderKey = ImmutableSet.of((Object)new XmlEncoderKey(namespace, SoapResponse.class), (Object)new XmlEncoderKey(namespace, SoapRequest.class));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(this.encoderKey);
    }

    @Override
    public MediaType getContentType() {
        return MediaTypes.APPLICATION_SOAP_XML;
    }

    @Override
    public T encode(S response) throws EncodingException {
        return (T)this.encode(response, null);
    }

    protected XmlObject getBodyContent(AbstractSoap<?> soap) throws EncodingException {
        OperationRequestEncoderKey key;
        OwsServiceCommunicationObject bodyContent = soap.getBodyContent();
        OwsOperationKey operationKey = new OwsOperationKey(bodyContent);
        MediaType mediaType = MediaTypes.APPLICATION_XML;
        if (bodyContent instanceof OwsServiceRequest) {
            key = new OperationRequestEncoderKey(operationKey, mediaType);
        } else if (bodyContent instanceof OwsServiceResponse) {
            key = new OperationResponseEncoderKey(operationKey, mediaType);
        } else {
            throw new EncodingException("unsupported SOAP type, neither request nor response " + soap, new Object[0]);
        }
        Encoder encoder = this.getEncoder((EncoderKey)key, new EncoderKey[0]);
        if (encoder == null) {
            throw new NoEncoderForKeyException((Object)key);
        }
        return (XmlObject)encoder.encode((Object)bodyContent);
    }

    protected String getExceptionActionURI(ExceptionCode exceptionCode) {
        if (exceptionCode instanceof OwsExceptionCode) {
            return "http://www.opengis.net/ows/1.1/Exception";
        }
        if (exceptionCode instanceof SwesExceptionCode) {
            return "http://www.opengis.net/swes/2.0/Exception";
        }
        if (exceptionCode instanceof SosExceptionCode) {
            return "http://www.opengis.net/def/serviceOperation/sos/core/2.0/Exception";
        }
        return "http://www.opengis.net/ows/1.1/Exception";
    }

    protected String getSoapFaultReasonText(ExceptionCode exceptionCode) {
        if (exceptionCode != null && exceptionCode.getSoapFaultReason() != null) {
            return exceptionCode.getSoapFaultReason();
        }
        return DEFAULT_FAULT_REASON;
    }
}

