/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import net.opengis.fes.x20.BBOXDocument;
import net.opengis.fes.x20.BBOXType;
import net.opengis.fes.x20.BinaryTemporalOpType;
import net.opengis.fes.x20.ComparisonOperatorsType;
import net.opengis.fes.x20.ConformanceType;
import net.opengis.fes.x20.DuringDocument;
import net.opengis.fes.x20.FilterCapabilitiesDocument;
import net.opengis.fes.x20.GeometryOperandsType;
import net.opengis.fes.x20.ScalarCapabilitiesType;
import net.opengis.fes.x20.SpatialCapabilitiesType;
import net.opengis.fes.x20.SpatialOperatorType;
import net.opengis.fes.x20.SpatialOperatorsType;
import net.opengis.fes.x20.TEqualsDocument;
import net.opengis.fes.x20.TemporalCapabilitiesType;
import net.opengis.fes.x20.TemporalOperandsType;
import net.opengis.fes.x20.TemporalOperatorType;
import net.opengis.fes.x20.TemporalOperatorsType;
import net.opengis.fes.x20.ValueReferenceDocument;
import net.opengis.fes.x20.impl.ComparisonOperatorNameTypeImpl;
import net.opengis.fes.x20.impl.SpatialOperatorNameTypeImpl;
import net.opengis.fes.x20.impl.TemporalOperatorNameTypeImpl;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.filter.FilterCapabilities;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.ows.OwsDomain;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.ConformanceClass;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FesEncoderv20
extends AbstractXmlEncoder<XmlObject, Object>
implements ConformanceClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(FesEncoderv20.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/fes/2.0", (Class[])new Class[]{TemporalFilter.class, FilterCapabilities.class, SpatialFilter.class});

    public FesEncoderv20() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        if (nameSpacePrefixMap != null) {
            nameSpacePrefixMap.put("http://www.opengis.net/fes/2.0", "fes");
        }
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{FilterConstants.FES_20_SCHEMA_LOCATION});
    }

    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException {
        XmlObject encodedObject = null;
        if (element instanceof FilterCapabilities) {
            encodedObject = this.encodeFilterCapabilities((FilterCapabilities)element);
        } else if (element instanceof TemporalFilter) {
            encodedObject = this.encodeTemporalFilter((TemporalFilter)element);
        } else if (element instanceof SpatialFilter) {
            encodedObject = this.encodeSpatialFilter((SpatialFilter)element);
        } else {
            throw new UnsupportedEncoderInputException((Encoder)this, element);
        }
        return encodedObject;
    }

    private XmlObject encodeTemporalFilter(TemporalFilter temporalFilter) throws EncodingException {
        switch (temporalFilter.getOperator()) {
            case TM_During: {
                return this.encodeTemporalFilterDuring(temporalFilter);
            }
            case TM_Equals: {
                return this.encodeTemporalFilterEquals(temporalFilter);
            }
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)temporalFilter);
    }

    private XmlObject encodeTemporalFilterDuring(TemporalFilter temporalFilter) throws EncodingException {
        DuringDocument duringDoc = DuringDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        BinaryTemporalOpType during = duringDoc.addNewDuring();
        if (!(temporalFilter.getTime() instanceof TimePeriod)) {
            throw new EncodingException("The temporal filter value is not a TimePeriod!", new Object[0]);
        }
        during.set(this.encodeObjectToXml("http://www.opengis.net/gml/3.2", temporalFilter.getTime(), EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT)));
        this.checkAndAddValueReference(during, temporalFilter);
        return duringDoc;
    }

    private XmlObject encodeTemporalFilterEquals(TemporalFilter temporalFilter) throws EncodingException {
        TEqualsDocument equalsDoc = TEqualsDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        BinaryTemporalOpType equals = equalsDoc.addNewTEquals();
        if (!(temporalFilter.getTime() instanceof TimeInstant)) {
            throw new EncodingException("The temporal filter value is not a TimeInstant!", new Object[0]);
        }
        equals.set(this.encodeObjectToXml("http://www.opengis.net/gml/3.2", temporalFilter.getTime(), EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT)));
        this.checkAndAddValueReference(equals, temporalFilter);
        return equalsDoc;
    }

    private XmlObject encodeExpression(Object object) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", object);
    }

    private void checkAndAddValueReference(BinaryTemporalOpType binaryTemporalOp, TemporalFilter temporalFilter) {
        if (temporalFilter.hasValueReference()) {
            binaryTemporalOp.setValueReference(temporalFilter.getValueReference());
        }
    }

    private XmlObject encodeSpatialFilter(SpatialFilter spatialFilter) throws EncodingException {
        BBOXDocument bboxDoc = BBOXDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        BBOXType bbox = bboxDoc.addNewBBOX();
        if (spatialFilter.hasValueReference()) {
            bbox.set(this.encodeReferenceValue(spatialFilter.getValueReference()));
        }
        bbox.setExpression(this.encodeExpression(spatialFilter.getGeometry()));
        return bbox;
    }

    private XmlObject encodeReferenceValue(String sosValueReference) {
        ValueReferenceDocument valueReferenceDoc = ValueReferenceDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        valueReferenceDoc.setValueReference(sosValueReference);
        return valueReferenceDoc;
    }

    private XmlObject encodeFilterCapabilities(FilterCapabilities sosFilterCaps) throws EncodingException {
        FilterCapabilitiesDocument.FilterCapabilities filterCapabilities = FilterCapabilitiesDocument.FilterCapabilities.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (sosFilterCaps.isSetCoinformance()) {
            this.setConformance(filterCapabilities.addNewConformance(), sosFilterCaps.getConformance());
        }
        if (sosFilterCaps.getComparisonOperators() != null && !sosFilterCaps.getComparisonOperators().isEmpty()) {
            this.setScalarFilterCapabilities(filterCapabilities.addNewScalarCapabilities(), sosFilterCaps);
        }
        if (sosFilterCaps.getSpatialOperands() != null && !sosFilterCaps.getSpatialOperands().isEmpty()) {
            this.setSpatialFilterCapabilities(filterCapabilities.addNewSpatialCapabilities(), sosFilterCaps);
        }
        if (sosFilterCaps.getTemporalOperands() != null && !sosFilterCaps.getTemporalOperands().isEmpty()) {
            this.setTemporalFilterCapabilities(filterCapabilities.addNewTemporalCapabilities(), sosFilterCaps);
        }
        return filterCapabilities;
    }

    private void setConformance(ConformanceType conformance, Collection<OwsDomain> sosConformance) throws EncodingException {
        for (OwsDomain owsDomainType : sosConformance) {
            XmlObject encodeObjectToXml = this.encodeObjectToXml("http://www.opengis.net/ows/1.1", owsDomainType);
            conformance.addNewConstraint().set(encodeObjectToXml);
        }
    }

    private void setSpatialFilterCapabilities(SpatialCapabilitiesType spatialCapabilitiesType, FilterCapabilities sosFilterCaps) throws EncodingException {
        if (sosFilterCaps.getSpatialOperands() != null && !sosFilterCaps.getSpatialOperands().isEmpty()) {
            GeometryOperandsType spatialOperands = spatialCapabilitiesType.addNewGeometryOperands();
            sosFilterCaps.getSpatialOperands().forEach(operand -> spatialOperands.addNewGeometryOperand().setName(operand));
        }
        if (sosFilterCaps.getSpatialOperators() != null && !sosFilterCaps.getSpatialOperators().isEmpty()) {
            SpatialOperatorsType spatialOps = spatialCapabilitiesType.addNewSpatialOperators();
            Set keys = sosFilterCaps.getSpatialOperators().keySet();
            for (FilterConstants.SpatialOperator spatialOperator : keys) {
                SpatialOperatorType operator = spatialOps.addNewSpatialOperator();
                operator.setName(this.getEnum4SpatialOperator(spatialOperator));
                GeometryOperandsType geomOps = operator.addNewGeometryOperands();
                ((SortedSet)sosFilterCaps.getSpatialOperators().get(spatialOperator)).forEach(operand -> geomOps.addNewGeometryOperand().setName(operand));
            }
        }
    }

    private void setTemporalFilterCapabilities(TemporalCapabilitiesType temporalCapabilitiesType, FilterCapabilities sosFilterCaps) throws EncodingException {
        if (sosFilterCaps.getTemporalOperands() != null && !sosFilterCaps.getTemporalOperands().isEmpty()) {
            TemporalOperandsType tempOperands = temporalCapabilitiesType.addNewTemporalOperands();
            sosFilterCaps.getTemporalOperands().forEach(operand -> tempOperands.addNewTemporalOperand().setName(operand));
        }
        if (sosFilterCaps.getTemporalOperators() != null && !sosFilterCaps.getTemporalOperators().isEmpty()) {
            TemporalOperatorsType temporalOps = temporalCapabilitiesType.addNewTemporalOperators();
            Set keys = sosFilterCaps.getTemporalOperators().keySet();
            for (FilterConstants.TimeOperator temporalOperator : keys) {
                TemporalOperatorType operator = temporalOps.addNewTemporalOperator();
                operator.setName(this.getEnum4TemporalOperator(temporalOperator));
                TemporalOperandsType bboxGeomOps = operator.addNewTemporalOperands();
                ((SortedSet)sosFilterCaps.getTemporalOperators().get(temporalOperator)).forEach(operand -> bboxGeomOps.addNewTemporalOperand().setName(operand));
            }
        }
    }

    private void setScalarFilterCapabilities(ScalarCapabilitiesType scalarCapabilitiesType, FilterCapabilities sosFilterCaps) throws EncodingException {
        if (sosFilterCaps.getComparisonOperators() != null && !sosFilterCaps.getComparisonOperators().isEmpty()) {
            ComparisonOperatorsType scalarOps = scalarCapabilitiesType.addNewComparisonOperators();
            for (FilterConstants.ComparisonOperator operator : sosFilterCaps.getComparisonOperators()) {
                scalarOps.addNewComparisonOperator().setName(this.getEnum4ComparisonOperator(operator));
            }
        }
    }

    private String getEnum4SpatialOperator(FilterConstants.SpatialOperator spatialOperator) throws EncodingException {
        switch (spatialOperator) {
            case BBOX: {
                return SpatialOperatorNameTypeImpl.BBOX.toString();
            }
            case Beyond: {
                return SpatialOperatorNameTypeImpl.BEYOND.toString();
            }
            case Contains: {
                return SpatialOperatorNameTypeImpl.CONTAINS.toString();
            }
            case Crosses: {
                return SpatialOperatorNameTypeImpl.CROSSES.toString();
            }
            case Disjoint: {
                return SpatialOperatorNameTypeImpl.DISJOINT.toString();
            }
            case DWithin: {
                return SpatialOperatorNameTypeImpl.D_WITHIN.toString();
            }
            case Equals: {
                return SpatialOperatorNameTypeImpl.EQUALS.toString();
            }
            case Intersects: {
                return SpatialOperatorNameTypeImpl.INTERSECTS.toString();
            }
            case Overlaps: {
                return SpatialOperatorNameTypeImpl.OVERLAPS.toString();
            }
            case Touches: {
                return SpatialOperatorNameTypeImpl.TOUCHES.toString();
            }
            case Within: {
                return SpatialOperatorNameTypeImpl.WITHIN.toString();
            }
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)spatialOperator);
    }

    private String getEnum4TemporalOperator(FilterConstants.TimeOperator temporalOperator) throws EncodingException {
        switch (temporalOperator) {
            case TM_After: {
                return TemporalOperatorNameTypeImpl.AFTER.toString();
            }
            case TM_Before: {
                return TemporalOperatorNameTypeImpl.BEFORE.toString();
            }
            case TM_Begins: {
                return TemporalOperatorNameTypeImpl.BEGINS.toString();
            }
            case TM_BegunBy: {
                return TemporalOperatorNameTypeImpl.BEGUN_BY.toString();
            }
            case TM_Contains: {
                return TemporalOperatorNameTypeImpl.T_CONTAINS.toString();
            }
            case TM_During: {
                return TemporalOperatorNameTypeImpl.DURING.toString();
            }
            case TM_EndedBy: {
                return TemporalOperatorNameTypeImpl.ENDED_BY.toString();
            }
            case TM_Ends: {
                return TemporalOperatorNameTypeImpl.ENDS.toString();
            }
            case TM_Equals: {
                return TemporalOperatorNameTypeImpl.T_EQUALS.toString();
            }
            case TM_Meets: {
                return TemporalOperatorNameTypeImpl.MEETS.toString();
            }
            case TM_MetBy: {
                return TemporalOperatorNameTypeImpl.MET_BY.toString();
            }
            case TM_OverlappedBy: {
                return TemporalOperatorNameTypeImpl.OVERLAPPED_BY.toString();
            }
            case TM_Overlaps: {
                return TemporalOperatorNameTypeImpl.T_OVERLAPS.toString();
            }
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)temporalOperator);
    }

    private String getEnum4ComparisonOperator(FilterConstants.ComparisonOperator comparisonOperator) throws EncodingException {
        switch (comparisonOperator) {
            case PropertyIsBetween: {
                return ComparisonOperatorNameTypeImpl.PROPERTY_IS_BETWEEN.toString();
            }
            case PropertyIsEqualTo: {
                return ComparisonOperatorNameTypeImpl.PROPERTY_IS_EQUAL_TO.toString();
            }
            case PropertyIsGreaterThan: {
                return ComparisonOperatorNameTypeImpl.PROPERTY_IS_GREATER_THAN.toString();
            }
            case PropertyIsGreaterThanOrEqualTo: {
                return ComparisonOperatorNameTypeImpl.PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO.toString();
            }
            case PropertyIsLessThan: {
                return ComparisonOperatorNameTypeImpl.PROPERTY_IS_LESS_THAN.toString();
            }
            case PropertyIsLessThanOrEqualTo: {
                return ComparisonOperatorNameTypeImpl.PROPERTY_IS_LESS_THAN_OR_EQUAL_TO.toString();
            }
            case PropertyIsLike: {
                return ComparisonOperatorNameTypeImpl.PROPERTY_IS_LIKE.toString();
            }
            case PropertyIsNil: {
                return ComparisonOperatorNameTypeImpl.PROPERTY_IS_NIL.toString();
            }
            case PropertyIsNotEqualTo: {
                return ComparisonOperatorNameTypeImpl.PROPERTY_IS_NOT_EQUAL_TO.toString();
            }
            case PropertyIsNull: {
                return ComparisonOperatorNameTypeImpl.PROPERTY_IS_NULL.toString();
            }
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)comparisonOperator);
    }
}

