/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import eu.europa.ec.inspire.schemas.omso.x30.PointObservationType;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import net.opengis.om.x20.OMObservationType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.inspire.omso.PointObservation;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.values.CvDiscretePointCoverage;
import org.n52.svalbard.encode.AbstractOmInspireEncoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointObservationTypeEncoder
extends AbstractOmInspireEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PointObservationTypeEncoder.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://inspire.ec.europa.eu/schemas/omso/3.0", (Class[])new Class[]{PointObservation.class});

    public PointObservationTypeEncoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    protected XmlObject createResult(OmObservation sosObservation) throws EncodingException {
        return this.encodeResult(sosObservation.getValue());
    }

    @Override
    protected XmlObject encodeResult(ObservationValue<?> observationValue) throws EncodingException {
        if (observationValue.getValue() instanceof CvDiscretePointCoverage) {
            return this.encodeObjectToXmlPropertyType("http://www.opengis.net/cv/0.2/gml32", observationValue.getValue());
        }
        return null;
    }

    @Override
    protected String getObservationType() {
        return "http://inspire.ec.europa.eu/featureconcept/PointObservation";
    }

    @Override
    public XmlObject encode(Object element, EncodingContext ec) throws EncodingException {
        return super.encode(element, ec);
    }

    @Override
    public void encode(Object objectToEncode, OutputStream outputStream, EncodingContext context) throws EncodingException {
        super.encode(objectToEncode, outputStream, context);
    }

    @Override
    protected OMObservationType createOmObservationType() {
        return PointObservationType.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }
}

