/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import eu.europa.ec.inspire.schemas.omso.x30.PointTimeSeriesObservationType;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.opengis.om.x20.OMObservationType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.inspire.omso.PointTimeSeriesObservation;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.svalbard.encode.AbstractOmInspireEncoder;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.write.PointTimeSeriesObservationXmlStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointTimeSeriesObservationTypeEncoder
extends AbstractOmInspireEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PointTimeSeriesObservationTypeEncoder.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://inspire.ec.europa.eu/schemas/omso/3.0", (Class[])new Class[]{PointTimeSeriesObservation.class});

    public PointTimeSeriesObservationTypeEncoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    protected XmlObject createResult(OmObservation sosObservation) throws EncodingException {
        return this.encodeResult(sosObservation.getValue());
    }

    @Override
    protected XmlObject encodeResult(ObservationValue<?> observationValue) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/waterml/2.0", observationValue);
    }

    @Override
    public boolean supportsResultStreamingForMergedValues() {
        return true;
    }

    @Override
    protected String getObservationType() {
        return "http://inspire.ec.europa.eu/featureconcept/PointTimeSeriesObservation";
    }

    @Override
    public XmlObject encode(Object element, EncodingContext ec) throws EncodingException {
        return super.encode(element, ec);
    }

    @Override
    public void encode(Object objectToEncode, OutputStream outputStream, EncodingContext context) throws EncodingException {
        if (objectToEncode instanceof OmObservation) {
            try {
                new PointTimeSeriesObservationXmlStreamWriter(context.with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions), outputStream, (OmObservation)objectToEncode).write();
            }
            catch (XMLStreamException xmlse) {
                throw new EncodingException("Error while writing element to stream!", (Throwable)xmlse);
            }
        }
        super.encode(objectToEncode, outputStream, context);
    }

    @Override
    protected OMObservationType createOmObservationType() {
        return PointTimeSeriesObservationType.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }
}

