/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.opengis.om.x20.OMObservationType;
import net.opengis.tsml.x10.MeasurementTVPPropertyType;
import net.opengis.tsml.x10.MeasurementTVPType;
import net.opengis.tsml.x10.PointMetadataDocument;
import net.opengis.tsml.x10.PointMetadataType;
import net.opengis.tsml.x10.TimeseriesMetadataType;
import net.opengis.tsml.x10.TimeseriesTVPDocument;
import net.opengis.tsml.x10.TimeseriesTVPType;
import org.apache.xmlbeans.GDurationBuilder;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.om.AbstractObservationValue;
import org.n52.shetland.ogc.om.MultiObservationValues;
import org.n52.shetland.ogc.om.ObservationType;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmObservableProperty;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.ogc.om.TimeValuePair;
import org.n52.shetland.ogc.om.series.MeasurementTimeseriesMetadata;
import org.n52.shetland.ogc.om.series.TimeseriesMetadata;
import org.n52.shetland.ogc.om.series.tsml.TimeseriesMLConstants;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.ProfileLevel;
import org.n52.shetland.ogc.om.values.ProfileValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.SweDataArrayValue;
import org.n52.shetland.ogc.om.values.TVPValue;
import org.n52.shetland.ogc.ows.exception.CodedException;
import org.n52.shetland.ogc.ows.exception.NoApplicableCodeException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.shetland.ogc.swe.simpleType.SweQuality;
import org.n52.shetland.ogc.swe.simpleType.SweQualityHolder;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractTsmlEncoderv10;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.WmlTmlHelper;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.write.TsmlTVPEncoderv10XmlStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsmlTVPEncoderv10
extends AbstractTsmlEncoderv10
implements WmlTmlHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsmlTVPEncoderv10.class);
    private static final Set<String> CONFORMANCE_CLASSES = Sets.newHashSet((Object[])new String[]{"http://www.opengis.net/spec/timeseries/1.0/conf/uml-measurement-timeseries-tvp-observation", "http://www.opengis.net/spec/timeseries/1.0/conf/uml-timeseries-tvp-observation", "http://www.opengis.net/spec/timeseries/1.0/conf/uml-measurement-timeseries-tvp-observation", "http://www.opengis.net/spec/timeseriesml/1.0/conf/xsd-xml-rules", "http://www.opengis.net/spec/timeseriesml/1.0/conf/xsd-timeseries-observation", "http://www.opengis.net/spec/timeseriesml/1.0/conf/xsd-timeseries-tvp-observation", "http://www.opengis.net/spec/timeseriesml/1.0/conf/xsd-measurement-timeseries-tvp"});
    private static final ImmutableSet<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)new ObservationType("http://www.opengis.net/def/observationType/timeseriesML/1.0/MeasurementTimeseriesTVPObservation")).build();
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{TsmlTVPEncoderv10.getDefaultEncoderKeys(), CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/tsml/1.0", (Class[])new Class[]{GetObservationResponse.class, OmObservation.class, SingleObservationValue.class, MultiObservationValues.class})});
    private static final Map<String, Map<String, Set<String>>> SUPPORTED_RESPONSE_FORMATS = Collections.singletonMap("SOS", Collections.singletonMap("2.0.0", Collections.singleton("http://www.opengis.net/tsml/1.0")));
    private static final String TIMESERIES_ID_PREFIX = "timeseries.";

    public TsmlTVPEncoderv10() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Map<String, Set<SupportedType>> getSupportedResponseFormatObservationTypes() {
        return Collections.singletonMap("http://www.opengis.net/tsml/1.0", this.getSupportedTypes());
    }

    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    public Set<String> getSupportedResponseFormats(String service, String version) {
        return SUPPORTED_RESPONSE_FORMATS.getOrDefault(service, Collections.emptyMap()).getOrDefault(version, Collections.emptySet());
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{TimeseriesMLConstants.TSML_10_SCHEMA_LOCATION, TimeseriesMLConstants.TSML_10_TS_SCHEMA_LOCATION});
    }

    public boolean supportsResultStreamingForMergedValues() {
        return true;
    }

    @Override
    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException, UnsupportedEncoderInputException {
        if (element instanceof ObservationValue) {
            return this.encodeResult((ObservationValue)element);
        }
        return super.encode(element, additionalValues);
    }

    @Override
    public void encode(Object objectToEncode, OutputStream outputStream, EncodingContext ctx) throws EncodingException {
        if (objectToEncode instanceof OmObservation) {
            try {
                new TsmlTVPEncoderv10XmlStreamWriter(ctx.with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions), outputStream, (OmObservation)objectToEncode).write();
            }
            catch (XMLStreamException xmlse) {
                throw new EncodingException("Error while writing element to stream!", (Throwable)xmlse);
            }
        } else {
            super.encode(objectToEncode, ctx);
        }
    }

    @Override
    protected XmlObject createResult(OmObservation sosObservation) throws EncodingException {
        try {
            return this.createMeasurementTimeseries(sosObservation);
        }
        catch (OwsExceptionReport ce) {
            throw new EncodingException((Throwable)ce);
        }
    }

    @Override
    protected XmlObject encodeResult(ObservationValue<?> observationValue) throws EncodingException {
        try {
            return this.createMeasurementTimeseries((AbstractObservationValue)observationValue);
        }
        catch (OwsExceptionReport ce) {
            throw new EncodingException((Throwable)ce);
        }
    }

    @Override
    protected void addObservationType(OMObservationType xbObservation, String observationType) {
        if (!Strings.isNullOrEmpty((String)observationType)) {
            if (observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement") || observationType.equals("http://www.opengis.net/def/observationType/timeseriesML/1.0/MeasurementTimeseriesTVPObservation")) {
                xbObservation.addNewType().setHref("http://www.opengis.net/def/observationType/timeseriesML/1.0/MeasurementTimeseriesTVPObservation");
            } else if (observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CategoryObservation") || observationType.equals("http://www.opengis.net/def/observationType/timeseriesML/1.0/CategoricalTimeseriesTVPObservation")) {
                xbObservation.addNewType().setHref("http://www.opengis.net/def/observationType/timeseriesML/1.0/CategoricalTimeseriesTVPObservation");
            }
        }
    }

    @Override
    protected OMObservationType createOmObservationType() {
        return OMObservationType.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    private XmlObject createMeasurementTimeseries(OmObservation sosObservation) throws OwsExceptionReport, EncodingException {
        String unit;
        TimeseriesTVPDocument measurementTimeseriesDoc = TimeseriesTVPDocument.Factory.newInstance();
        TimeseriesTVPType measurementTimeseries = measurementTimeseriesDoc.addNewTimeseriesTVP();
        measurementTimeseries.setId(TIMESERIES_ID_PREFIX + sosObservation.getObservationID());
        MeasurementTimeseriesMetadata timeseriesMetadata = new MeasurementTimeseriesMetadata().setCumulative(false);
        if (sosObservation.isSetValue() && sosObservation.getValue().isSetValue() && sosObservation.getValue().getValue().getClass().isAssignableFrom(TVPValue.class) && sosObservation.getObservationConstellation().isSetMetadata() && sosObservation.getObservationConstellation().getMetadata().isSetTimeseriesMetadata()) {
            timeseriesMetadata = sosObservation.getObservationConstellation().getMetadata().getTimeseriesmetadata();
        }
        this.addTimeseriesMetadata(measurementTimeseries, sosObservation.getPhenomenonTime().getGmlId(), (TimeseriesMetadata)timeseriesMetadata);
        TimeseriesTVPType.DefaultPointMetadata xbMetaComponent = measurementTimeseries.addNewDefaultPointMetadata();
        PointMetadataDocument xbDefMeasureMetaComponent = PointMetadataDocument.Factory.newInstance();
        PointMetadataType defaultTVPMeasurementMetadata = xbDefMeasureMetaComponent.addNewPointMetadata();
        TimeseriesMLConstants.InterpolationType interpolationType = TimeseriesMLConstants.InterpolationType.Continuous;
        if (sosObservation.isSetValue() && sosObservation.getValue().isSetValue() && sosObservation.getValue().getValue().getClass().isAssignableFrom(TVPValue.class) && sosObservation.getObservationConstellation().isSetDefaultPointMetadata() && sosObservation.getObservationConstellation().getDefaultPointMetadata().isSetDefaultTVPMeasurementMetadata() && sosObservation.getObservationConstellation().getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().isSetInterpolationType()) {
            interpolationType = (TimeseriesMLConstants.InterpolationType)sosObservation.getObservationConstellation().getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().getInterpolationtype();
        }
        defaultTVPMeasurementMetadata.addNewInterpolationType().setHref(interpolationType.getIdentifier());
        xbDefMeasureMetaComponent.getPointMetadata().getInterpolationType().setTitle(interpolationType.getTitle());
        if (sosObservation.getObservationConstellation().getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().isSetAggregationDuration()) {
            GDurationBuilder gDurationBuilder = new GDurationBuilder(sosObservation.getObservationConstellation().getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().getAggregationDuration());
            xbDefMeasureMetaComponent.getPointMetadata().setAggregationDuration(gDurationBuilder.toGDuration());
        }
        if ((unit = this.addValues(measurementTimeseries, sosObservation.getValue())) != null && !unit.isEmpty()) {
            defaultTVPMeasurementMetadata.addNewUom().setCode(unit);
        } else {
            OmObservableProperty observableProperty = (OmObservableProperty)sosObservation.getObservationConstellation().getObservableProperty();
            if (observableProperty.isSetUnit()) {
                defaultTVPMeasurementMetadata.addNewUom().setCode(observableProperty.getUnit());
            }
        }
        xbMetaComponent.set((XmlObject)xbDefMeasureMetaComponent);
        return measurementTimeseriesDoc;
    }

    private XmlObject createMeasurementTimeseries(AbstractObservationValue<?> observationValue) throws CodedException, EncodingException {
        TimeseriesTVPDocument measurementTimeseriesDoc = TimeseriesTVPDocument.Factory.newInstance();
        TimeseriesTVPType measurementTimeseries = measurementTimeseriesDoc.addNewTimeseriesTVP();
        measurementTimeseries.setId(TIMESERIES_ID_PREFIX + observationValue.getObservationID());
        MeasurementTimeseriesMetadata timeseriesMetadata = new MeasurementTimeseriesMetadata().setCumulative(false);
        if (observationValue.isSetValue() && observationValue.isSetMetadata() && observationValue.getMetadata().isSetTimeseriesMetadata()) {
            timeseriesMetadata = observationValue.getMetadata().getTimeseriesmetadata();
        }
        this.addTimeseriesMetadata(measurementTimeseries, observationValue.getPhenomenonTime().getGmlId(), (TimeseriesMetadata)timeseriesMetadata);
        TimeseriesTVPType.DefaultPointMetadata xbMetaComponent = measurementTimeseries.addNewDefaultPointMetadata();
        PointMetadataDocument xbDefMeasureMetaComponent = PointMetadataDocument.Factory.newInstance();
        PointMetadataType defaultTVPMeasurementMetadata = xbDefMeasureMetaComponent.addNewPointMetadata();
        TimeseriesMLConstants.InterpolationType interpolationType = TimeseriesMLConstants.InterpolationType.Continuous;
        if (observationValue.isSetValue() && observationValue.isSetDefaultPointMetadata() && observationValue.getDefaultPointMetadata().isSetDefaultTVPMeasurementMetadata() && observationValue.getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().isSetInterpolationType()) {
            interpolationType = (TimeseriesMLConstants.InterpolationType)observationValue.getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().getInterpolationtype();
        }
        defaultTVPMeasurementMetadata.addNewInterpolationType().setHref(interpolationType.getIdentifier());
        xbDefMeasureMetaComponent.getPointMetadata().getInterpolationType().setTitle(interpolationType.getTitle());
        String unit = this.addValues(measurementTimeseries, (ObservationValue<?>)observationValue);
        if (unit != null && !unit.isEmpty()) {
            defaultTVPMeasurementMetadata.addNewUom().setCode(unit);
        }
        xbMetaComponent.set((XmlObject)xbDefMeasureMetaComponent);
        return measurementTimeseriesDoc;
    }

    private String addValues(TimeseriesTVPType measurementTimeseries, ObservationValue<?> observationValue) throws CodedException, EncodingException {
        String unit;
        block9: {
            block7: {
                block11: {
                    String time;
                    SingleObservationValue singleObservationValue;
                    block10: {
                        block8: {
                            unit = null;
                            if (!(observationValue instanceof SingleObservationValue)) break block7;
                            singleObservationValue = (SingleObservationValue)observationValue;
                            time = this.getTimeString(singleObservationValue.getPhenomenonTime());
                            unit = singleObservationValue.getValue().getUnit();
                            if (!(singleObservationValue.getValue() instanceof QuantityValue)) break block8;
                            QuantityValue quantityValue = (QuantityValue)singleObservationValue.getValue();
                            measurementTimeseries.addNewPoint().set((XmlObject)this.addValuesToMeasurementTVP(time, quantityValue));
                            break block9;
                        }
                        if (!(singleObservationValue.getValue() instanceof CountValue)) break block10;
                        CountValue countValue = (CountValue)singleObservationValue.getValue();
                        measurementTimeseries.addNewPoint().set((XmlObject)this.addValuesToMeasurementTVP(time, countValue));
                        break block9;
                    }
                    if (!(singleObservationValue.getValue() instanceof ProfileValue)) break block11;
                    ProfileValue profileValue = (ProfileValue)singleObservationValue.getValue();
                    if (!profileValue.isSetValue() || !(((ProfileLevel)profileValue.getValue().iterator().next()).getSimpleValue() instanceof QuantityValue)) break block9;
                    QuantityValue quantityValue = (QuantityValue)((ProfileLevel)profileValue.getValue().iterator().next()).getSimpleValue();
                    measurementTimeseries.addNewPoint().set((XmlObject)this.addValuesToMeasurementTVP(time, quantityValue));
                    break block9;
                }
                if (!this.checkSweDataArray(observationValue.getValue())) break block9;
                SweDataArrayValue sweDataArrayValue = (SweDataArrayValue)observationValue.getValue();
                for (List list : sweDataArrayValue.getValue().getValues()) {
                    for (int i = 0; i < list.size(); i += 2) {
                        measurementTimeseries.addNewPoint().set((XmlObject)this.addValuesToMeasurementTVP((String)list.get(i), (String)list.get(i + 1)));
                    }
                }
                break block9;
            }
            if (observationValue instanceof MultiObservationValues) {
                MultiObservationValues mov = (MultiObservationValues)observationValue;
                TVPValue tvpValue = (TVPValue)mov.getValue();
                List timeValuePairs = tvpValue.getValue();
                unit = tvpValue.getUnit();
                for (TimeValuePair timeValuePair : timeValuePairs) {
                    String time = this.getTimeString(timeValuePair.getTime());
                    if (timeValuePair.getValue() instanceof QuantityValue) {
                        QuantityValue quantityValue = (QuantityValue)timeValuePair.getValue();
                        measurementTimeseries.addNewPoint().set((XmlObject)this.addValuesToMeasurementTVP(time, quantityValue));
                        continue;
                    }
                    if (timeValuePair.getValue() instanceof ProfileValue) {
                        ProfileValue profileValue = (ProfileValue)timeValuePair.getValue();
                        if (!profileValue.isSetValue() || !(((ProfileLevel)profileValue.getValue().iterator().next()).getSimpleValue() instanceof QuantityValue)) continue;
                        QuantityValue quantityValue = (QuantityValue)((ProfileLevel)profileValue.getValue().iterator().next()).getSimpleValue();
                        measurementTimeseries.addNewPoint().set((XmlObject)this.addValuesToMeasurementTVP(time, quantityValue));
                        continue;
                    }
                    if (timeValuePair.getValue() instanceof CountValue) {
                        CountValue countValue = (CountValue)timeValuePair.getValue();
                        measurementTimeseries.addNewPoint().set((XmlObject)this.addValuesToMeasurementTVP(time, countValue));
                        continue;
                    }
                    throw new NoApplicableCodeException().withMessage("The types of values '%s' is not yet supported", new Object[]{mov.getValue().getClass().getSimpleName()});
                }
            }
        }
        return unit;
    }

    private MeasurementTVPPropertyType addValuesToMeasurementTVP(String time, String value) {
        MeasurementTVPType measurementTVP = MeasurementTVPType.Factory.newInstance();
        this.addValuesToMeasurementTVP(measurementTVP, time, value);
        MeasurementTVPPropertyType measurementTVPProperty = MeasurementTVPPropertyType.Factory.newInstance();
        measurementTVPProperty.setMeasurementTVP(measurementTVP);
        return measurementTVPProperty;
    }

    private MeasurementTVPPropertyType addValuesToMeasurementTVP(String time, QuantityValue value) throws EncodingException {
        MeasurementTVPType measurementTVP = MeasurementTVPType.Factory.newInstance();
        this.addValuesToMeasurementTVP(measurementTVP, time, value);
        MeasurementTVPPropertyType measurementTVPProperty = MeasurementTVPPropertyType.Factory.newInstance();
        measurementTVPProperty.setMeasurementTVP(measurementTVP);
        return measurementTVPProperty;
    }

    private MeasurementTVPPropertyType addValuesToMeasurementTVP(String time, CountValue value) {
        MeasurementTVPType measurementTVP = MeasurementTVPType.Factory.newInstance();
        this.addValuesToMeasurementTVP(measurementTVP, time, value);
        MeasurementTVPPropertyType measurementTVPProperty = MeasurementTVPPropertyType.Factory.newInstance();
        measurementTVPProperty.setMeasurementTVP(measurementTVP);
        return measurementTVPProperty;
    }

    private void addValuesToMeasurementTVP(MeasurementTVPType measurementTVP, String time, String value) {
        measurementTVP.addNewTime().setStringValue(time);
        if (value == null || value.isEmpty()) {
            measurementTVP.addNewValue().setNil();
            this.addMeasurmentMetadataMissing(measurementTVP.addNewMetadata().addNewPointMetadata());
        } else {
            measurementTVP.addNewValue().setStringValue(value);
        }
    }

    private void addValuesToMeasurementTVP(MeasurementTVPType measurementTVP, String time, QuantityValue value) throws EncodingException {
        measurementTVP.addNewTime().setStringValue(time);
        if (value.isSetValue()) {
            measurementTVP.addNewValue().setStringValue(value.getValue().toPlainString());
        } else {
            measurementTVP.addNewValue().setNil();
            if (value.isSetQuality()) {
                this.addMeasurmentMetadata(measurementTVP.addNewMetadata().addNewPointMetadata(), value.getQuality());
            } else {
                this.addMeasurmentMetadataMissing(measurementTVP.addNewMetadata().addNewPointMetadata());
            }
        }
    }

    private void addValuesToMeasurementTVP(MeasurementTVPType measurementTVPType, String time, CountValue value) {
        this.addValuesToMeasurementTVP(measurementTVPType, time, value.isSetValue() ? Integer.toString(value.getValue()) : null);
    }

    private void addMeasurmentMetadataMissing(PointMetadataType metadata) {
        metadata.addNewNilReason().setNilReason((Object)"missing");
    }

    private void addMeasurmentMetadata(PointMetadataType metadata, SweQualityHolder quality) throws EncodingException {
        if (quality.isSetReferences() && quality.getReferences().containsKey("censoredReason")) {
            ReferenceType reference = (ReferenceType)quality.getReferences().get("censoredReason");
            XmlObject xmlReferenceType = this.encodeGML(reference);
            metadata.addNewCensoredReason().set(xmlReferenceType);
        }
        if (quality.isSetQuality()) {
            for (SweQuality qualifier : quality.getQuality()) {
                if (!(qualifier instanceof SweQuantity)) continue;
                XmlObject xmlQuality = this.encodeSweCommon(quality);
                metadata.addNewQualifier().addNewQuantity().set(xmlQuality);
            }
        }
    }

    private void addTimeseriesMetadata(TimeseriesTVPType mtt, String gmlId, TimeseriesMetadata timeseriesMetadata) {
        TimeseriesMetadataType mtmt = (TimeseriesMetadataType)mtt.addNewMetadata().addNewTimeseriesMetadata().substitute(TimeseriesMLConstants.QN_MEASUREMENT_TIMESERIES_METADATA, TimeseriesMetadataType.type);
        this.createMeasurementTimeseriesMetadataType(mtmt, gmlId);
        if (timeseriesMetadata != null && timeseriesMetadata.getClass().isAssignableFrom(MeasurementTimeseriesMetadata.class)) {
            mtmt.setCumulative(((MeasurementTimeseriesMetadata)timeseriesMetadata).isCumulative());
        }
    }

    private TimeseriesMetadataType createMeasurementTimeseriesMetadataType(TimeseriesMetadataType mtmt, String gmlId) {
        mtmt.addNewTemporalExtent().setHref("#" + gmlId);
        return mtmt;
    }
}

