/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.exception.CompositeException;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.W3CConstants;
import org.n52.shetland.w3c.soap.AbstractSoap;
import org.n52.shetland.w3c.soap.SoapHeader;
import org.n52.shetland.w3c.wsa.WsaActionHeader;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.XmlNamespaceDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.encode.SchemaRepository;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSoapDecoder
extends AbstractXmlDecoder<XmlObject, AbstractSoap<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSoapDecoder.class);
    private final Set<DecoderKey> decoderKeys;
    private SchemaRepository schemaRepository;

    public AbstractSoapDecoder(String namespace) {
        this.decoderKeys = Collections.singleton(new XmlNamespaceDecoderKey(namespace, XmlObject.class));
    }

    @Inject
    public void setSchemaRepository(SchemaRepository schemaRepository) {
        this.schemaRepository = schemaRepository;
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(this.decoderKeys);
    }

    public AbstractSoap<?> decode(XmlObject xmlObject) throws DecodingException {
        try {
            return this.createEnvelope(xmlObject);
        }
        catch (DecodingException de) {
            return this.createFault(de);
        }
    }

    protected abstract AbstractSoap<?> createEnvelope(XmlObject var1) throws DecodingException;

    protected abstract AbstractSoap<?> createFault(DecodingException var1);

    protected String checkSoapAction(String soapAction, List<SoapHeader> soapHeaders) {
        if (soapAction != null && !soapAction.isEmpty()) {
            return soapAction;
        }
        if (CollectionHelper.isNotEmpty(soapHeaders)) {
            for (SoapHeader soapHeader : soapHeaders) {
                if (!"http://www.w3.org/2005/08/addressing".equals(soapHeader.getNamespace()) || !(soapHeader instanceof WsaActionHeader)) continue;
                return ((WsaActionHeader)soapHeader).getValue();
            }
        }
        return null;
    }

    protected String getFaultReasons(DecodingException de) {
        if (de.getCause() instanceof CompositeException) {
            return Joiner.on((String)"\n").join((Iterable)((CompositeException)de.getCause()).getExceptions().stream().map(e -> e.getMessage()).collect(Collectors.toList()));
        }
        return de.getMessage();
    }

    protected void fixNamespaceForXsiType(XmlObject content, Map<?, ?> namespaces) {
        XmlCursor cursor = content.newCursor();
        while (cursor.hasNextToken()) {
            String[] toks;
            String xsiType;
            if (!cursor.toNextToken().isStart() || (xsiType = cursor.getAttributeText(W3CConstants.QN_XSI_TYPE)) == null || (toks = xsiType.split(":")).length <= 1) continue;
            String prefix = toks[0];
            String localName = toks[1];
            String namespace = (String)namespaces.get(prefix);
            if (Strings.isNullOrEmpty((String)namespace)) {
                namespace = this.schemaRepository.getNamespaceFor(prefix);
            }
            if (Strings.isNullOrEmpty((String)namespace)) continue;
            cursor.setAttributeText(W3CConstants.QN_XSI_TYPE, Joiner.on((String)":").join((Object)XmlHelper.getPrefixForNamespace((XmlObject)content, (String)((String)namespaces.get(prefix))), (Object)localName, new Object[0]));
        }
        cursor.dispose();
    }
}

