/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.opengis.gml.x32.FeaturePropertyType;
import net.opengis.ifoi.x10.InsertFeatureOfInterestDocument;
import net.opengis.ifoi.x10.InsertFeatureOfInterestType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.sos.ifoi.InsertFeatureOfInterestRequest;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertFeatureOfInterestDecoder
extends AbstractXmlDecoder<XmlObject, InsertFeatureOfInterestRequest> {
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/ifoi/1.0", (Class[])new Class[]{InsertFeatureOfInterestDocument.class}), CodingHelper.xmlDecoderKeysForOperation((String)"SOS", (String)"2.0.0", (String[])new String[]{"InsertFeatureOfInterest"})});
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertFeatureOfInterestDecoder.class);

    public InsertFeatureOfInterestDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public InsertFeatureOfInterestRequest decode(XmlObject xmlObject) throws DecodingException {
        LOGGER.debug(String.format("REQUESTTYPE: %s", xmlObject != null ? xmlObject.getClass() : "null recevied"));
        if (xmlObject instanceof InsertFeatureOfInterestDocument) {
            InsertFeatureOfInterestDocument ifoid = (InsertFeatureOfInterestDocument)xmlObject;
            InsertFeatureOfInterestRequest decodedRequest = this.parseInsertFeatureOfInterest(ifoid);
            LOGGER.debug(String.format("Decoded request: %s", decodedRequest));
            return decodedRequest;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)xmlObject);
    }

    private InsertFeatureOfInterestRequest parseInsertFeatureOfInterest(InsertFeatureOfInterestDocument ifoid) throws DecodingException {
        InsertFeatureOfInterestRequest request = null;
        InsertFeatureOfInterestType ifoit = ifoid.getInsertFeatureOfInterest();
        if (ifoit != null) {
            request = new InsertFeatureOfInterestRequest();
            request.setVersion(ifoit.getVersion());
            request.setService(ifoit.getService());
            if (CollectionHelper.isNotNullOrEmpty((Object[])ifoit.getFeatureMemberArray())) {
                this.parseFeatureMember(ifoit, request);
            }
        } else {
            throw new DecodingException("Received XML document is not valid. Set log level to debug to get more details", new Object[0]);
        }
        return request;
    }

    private void parseFeatureMember(InsertFeatureOfInterestType ifoit, InsertFeatureOfInterestRequest request) throws DecodingException {
        for (FeaturePropertyType fpt : ifoit.getFeatureMemberArray()) {
            Object decodedObject = this.decodeXmlElement((XmlObject)fpt);
            if (decodedObject == null || !(decodedObject instanceof AbstractFeature)) continue;
            request.addFeatureMember((AbstractFeature)decodedObject);
        }
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.emptySet();
    }

    public Set<String> getConformanceClasses() {
        return Sets.newHashSet((Object[])new String[]{"http://www.opengis.net/spec/SOS/2.0/conf/foi"});
    }
}

