/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Set;
import net.opengis.sosro.x10.RelatedOfferingsPropertyType;
import net.opengis.sosro.x10.RelatedOfferingsType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.sos.ro.OfferingContext;
import org.n52.shetland.ogc.sos.ro.RelatedOfferings;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedOfferingTypeDecoder
extends AbstractXmlDecoder<RelatedOfferingsPropertyType, RelatedOfferings> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelatedOfferingTypeDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sosro/1.0", (Class[])new Class[]{RelatedOfferingsPropertyType.class});

    public RelatedOfferingTypeDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public RelatedOfferings decode(RelatedOfferingsPropertyType rot) throws DecodingException {
        RelatedOfferings relatedOfferings = new RelatedOfferings();
        relatedOfferings.setNamespace("http://www.opengis.net/sosro/1.0").setDefinition("relatedOfferings").setIdentifier("relatedOfferings");
        for (RelatedOfferingsType.RelatedOffering relatedOffering : rot.getRelatedOfferings().getRelatedOfferingArray()) {
            relatedOfferings.getValue().add(this.parseRelatedOffering(relatedOffering));
        }
        return relatedOfferings;
    }

    private OfferingContext parseRelatedOffering(RelatedOfferingsType.RelatedOffering relatedOffering) throws DecodingException {
        ReferenceType role = (ReferenceType)this.decodeXmlElement((XmlObject)relatedOffering.getOfferingContext().getRole());
        ReferenceType relOff = (ReferenceType)this.decodeXmlElement((XmlObject)relatedOffering.getOfferingContext().getRelatedOffering());
        return new OfferingContext(role, relOff);
    }
}

