/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.n52.shetland.aqd.AbstractEReportingHeader;
import org.n52.shetland.aqd.EReportingHeader;
import org.n52.shetland.aqd.ReportObligationType;
import org.n52.shetland.aqd.ReportObligations;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.shetland.util.IdGenerator;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.svalbard.encode.AbstractAqdResponseEncoder;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.write.AqdGetObservationResponseXmlStreamWriter;

public class AqdGetObservationResponseEncoder
extends AbstractAqdResponseEncoder<GetObservationResponse> {
    public AqdGetObservationResponseEncoder() {
        super(SosConstants.Operations.GetObservation.name(), GetObservationResponse.class);
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations() {
        return Collections.emptySet();
    }

    @Override
    protected XmlObject create(GetObservationResponse response) throws EncodingException {
        try {
            FeatureCollection featureCollection = this.createFeatureCollection(response);
            EReportingHeader eReportingHeader = this.getEReportingHeader(this.getReportObligationType(response));
            featureCollection.addMember((AbstractFeature)eReportingHeader);
            TimePeriod timePeriod = new TimePeriod();
            TimeInstant resultTime = new TimeInstant(new DateTime(DateTimeZone.UTC));
            int counter = 1;
            while (response.getObservationCollection().hasNext()) {
                OmObservation observation = (OmObservation)response.getObservationCollection().next();
                this.processObservation(observation, timePeriod, resultTime, featureCollection, (AbstractEReportingHeader)eReportingHeader, counter++);
            }
            if (!timePeriod.isEmpty()) {
                eReportingHeader.setReportingPeriod(Referenceable.of((Object)timePeriod));
            }
            EncodingContext ctx = EncodingContext.empty().with((Enum)XmlEncoderFlags.ENCODE_NAMESPACE, (Object)"http://www.opengis.net/om/2.0").with((Enum)XmlBeansEncodingFlags.DOCUMENT);
            return this.encodeGml(ctx, featureCollection);
        }
        catch (OwsExceptionReport ex) {
            throw new EncodingException((Throwable)ex);
        }
    }

    @Override
    protected void create(GetObservationResponse response, OutputStream outputStream, EncodingContext ctx) throws EncodingException {
        TimePeriod timePeriod;
        EReportingHeader eReportingHeader;
        FeatureCollection featureCollection = this.createFeatureCollection(response);
        try {
            eReportingHeader = this.getEReportingHeader(this.getReportObligationType(response));
            featureCollection.addMember((AbstractFeature)eReportingHeader);
            timePeriod = this.addToFeatureCollectionAndGetTimePeriod(featureCollection, response, eReportingHeader);
        }
        catch (OwsExceptionReport ex) {
            throw new EncodingException((Throwable)ex);
        }
        if (!timePeriod.isEmpty()) {
            eReportingHeader.setReportingPeriod(Referenceable.of((Object)timePeriod));
        }
        try {
            EncodingContext context = ctx.with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions).with((Enum)XmlEncoderFlags.ENCODE_NAMESPACE, (Object)"http://www.opengis.net/om/2.0").with((Enum)XmlBeansEncodingFlags.DOCUMENT);
            new AqdGetObservationResponseXmlStreamWriter(context, outputStream, featureCollection).write();
        }
        catch (XMLStreamException xmlse) {
            throw new EncodingException("Error while writing element to stream!", (Throwable)xmlse);
        }
    }

    private ReportObligationType getReportObligationType(GetObservationResponse response) throws OwsExceptionReport {
        return ReportObligations.getFlow((Extensions)response.getExtensions());
    }

    private TimePeriod addToFeatureCollectionAndGetTimePeriod(FeatureCollection featureCollection, GetObservationResponse response, EReportingHeader eReportingHeader) throws OwsExceptionReport {
        TimeInstant resultTime = new TimeInstant(new DateTime(DateTimeZone.UTC));
        TimePeriod timePeriod = new TimePeriod();
        int counter = 1;
        while (response.getObservationCollection().hasNext()) {
            OmObservation observation = (OmObservation)response.getObservationCollection().next();
            this.processObservation(observation, timePeriod, resultTime, featureCollection, (AbstractEReportingHeader)eReportingHeader, counter++);
        }
        return timePeriod;
    }

    private FeatureCollection createFeatureCollection(GetObservationResponse response) throws EncodingException {
        FeatureCollection featureCollection = new FeatureCollection();
        featureCollection.setGmlId("fc_" + IdGenerator.generate((String)new DateTime().toString()));
        return featureCollection;
    }
}

