/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import eu.europa.ec.inspire.schemas.ompr.x30.ProcessDocument;
import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.inspire.ompr.Process;
import org.n52.shetland.ogc.sos.SosProcedureDescription;
import org.n52.svalbard.encode.ClassToClassEncoderKey;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ProcessTypeEncoder;
import org.n52.svalbard.encode.XmlDocumentEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDocumentEncoder
extends ProcessTypeEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDocumentEncoder.class);
    private static final Set<EncoderKey> ENCODER_KEYS = Sets.newHashSet((Object[])new EncoderKey[]{new ClassToClassEncoderKey(Process.class, ProcessDocument.class), new XmlDocumentEncoderKey("http://inspire.ec.europa.eu/schemas/ompr/3.0", Process.class), new XmlDocumentEncoderKey("http://inspire.ec.europa.eu/schemas/ompr/3.0", SosProcedureDescription.class), new XmlDocumentEncoderKey("http://inspire.ec.europa.eu/featureconcept/Process", Process.class), new XmlDocumentEncoderKey("http://inspire.ec.europa.eu/featureconcept/Process", SosProcedureDescription.class)});

    public ProcessDocumentEncoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    @Override
    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    public XmlObject encode(Process process) throws EncodingException {
        return this.encode(process, EncodingContext.empty());
    }

    @Override
    public XmlObject encode(Process process, EncodingContext context) throws EncodingException {
        ProcessDocument pd = ProcessDocument.Factory.newInstance();
        pd.setProcess(this.createProcess(process));
        return pd;
    }
}

