/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import net.opengis.swes.x20.ExtensibleRequestType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.ows.extension.Extension;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swes.SwesExtension;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.exception.DecodingException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSwesDecoderv20<S>
extends AbstractXmlDecoder<XmlObject, S> {
    protected Extensions parseExtensibleRequest(ExtensibleRequestType extensibleRequestType) throws DecodingException {
        return this.parseExtensibleRequestExtension(extensibleRequestType.getExtensionArray());
    }

    protected Extensions parseExtensibleRequestExtension(XmlObject[] extensionArray) throws DecodingException {
        if (CollectionHelper.isNotNullOrEmpty((Object[])extensionArray)) {
            Extensions extensions = new Extensions();
            for (XmlObject xbExtension : extensionArray) {
                Object obj = this.decodeXmlElement(xbExtension);
                if (obj instanceof Extension) {
                    extensions.addExtension((Extension)obj);
                    continue;
                }
                if (!(obj instanceof SweAbstractDataComponent)) continue;
                SwesExtension swesExtension = new SwesExtension();
                swesExtension.setIdentifier(((SweAbstractDataComponent)obj).getIdentifier());
                swesExtension.setDefinition(((SweAbstractDataComponent)obj).getDefinition());
                extensions.addExtension((Extension)swesExtension);
            }
            return extensions;
        }
        return null;
    }

    protected void checkFormatWithNamespace(String procedureDescriptionFormat, String namespace) throws DecodingException {
        if (!procedureDescriptionFormat.equals(namespace) && !procedureDescriptionFormat.contains(namespace)) {
            throw new DecodingException("The procedure description namespace '%s' does not match the procedureDescriptionFormat '%s'", namespace, new Object[]{procedureDescriptionFormat});
        }
    }

    protected Node getNodeFromNodeList(NodeList nodeList) {
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                return nodeList.item(i);
            }
        }
        return null;
    }
}

