/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.opengis.sosdo.x20.DeleteObservationDocument;
import net.opengis.sosdo.x20.DeleteObservationType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.sos.delobs.DeleteObservationConstants;
import org.n52.shetland.ogc.sos.delobs.DeleteObservationRequest;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteObservationV20Decoder
extends AbstractXmlDecoder<XmlObject, DeleteObservationRequest> {
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sosdo/2.0", (Class[])new Class[]{DeleteObservationDocument.class}), CodingHelper.xmlDecoderKeysForOperation((String)"SOS", (String)"2.0.0", (Enum[])new Enum[]{DeleteObservationConstants.Operations.DeleteObservation})});
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteObservationV20Decoder.class);

    public DeleteObservationV20Decoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public DeleteObservationRequest decode(XmlObject xmlObject) throws DecodingException {
        LOGGER.debug(String.format("REQUESTTYPE: %s", xmlObject != null ? xmlObject.getClass() : "null recevied"));
        if (xmlObject instanceof DeleteObservationDocument) {
            DeleteObservationDocument delObsDoc = (DeleteObservationDocument)xmlObject;
            DeleteObservationRequest decodedRequest = this.parseDeleteObservation(delObsDoc);
            LOGGER.debug(String.format("Decoded request: %s", decodedRequest));
            return decodedRequest;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)xmlObject);
    }

    private DeleteObservationRequest parseDeleteObservation(DeleteObservationDocument xbDelObsDoc) throws DecodingException {
        DeleteObservationRequest delObsRequest = null;
        DeleteObservationType xbDelObsType = xbDelObsDoc.getDeleteObservation();
        if (xbDelObsType != null) {
            delObsRequest = new DeleteObservationRequest("http://www.opengis.net/sosdo/2.0");
            delObsRequest.setVersion(xbDelObsType.getVersion());
            delObsRequest.setService(xbDelObsType.getService());
            if (CollectionHelper.isNotNullOrEmpty((Object[])xbDelObsType.getObservationArray())) {
                delObsRequest.setObservationIdentifiers((Collection)Sets.newHashSet((Object[])xbDelObsType.getObservationArray()));
            } else {
                this.parseProcedure(xbDelObsType, delObsRequest);
                this.parseObservedProperty(xbDelObsType, delObsRequest);
                this.parseFeatureOfInterest(xbDelObsType, delObsRequest);
                this.parseOffering(xbDelObsType, delObsRequest);
                this.parseTemporalFilter(xbDelObsType, delObsRequest);
            }
        } else {
            throw new DecodingException("Received XML document is not valid. Set log level to debug to get more details", new Object[0]);
        }
        return delObsRequest;
    }

    private void parseProcedure(DeleteObservationType dot, DeleteObservationRequest request) {
        if (CollectionHelper.isNotNullOrEmpty((Object[])dot.getProcedureArray())) {
            request.setProcedures((Collection)Sets.newHashSet((Object[])dot.getProcedureArray()));
        }
    }

    private void parseObservedProperty(DeleteObservationType dot, DeleteObservationRequest request) {
        if (CollectionHelper.isNotNullOrEmpty((Object[])dot.getObservedPropertyArray())) {
            request.setObservedProperties((Collection)Sets.newHashSet((Object[])dot.getObservedPropertyArray()));
        }
    }

    private void parseFeatureOfInterest(DeleteObservationType dot, DeleteObservationRequest request) {
        if (CollectionHelper.isNotNullOrEmpty((Object[])dot.getFeatureOfInterestArray())) {
            request.setFeatureIdentifiers((Collection)Sets.newHashSet((Object[])dot.getFeatureOfInterestArray()));
        }
    }

    private void parseOffering(DeleteObservationType dot, DeleteObservationRequest request) {
        if (CollectionHelper.isNotNullOrEmpty((Object[])dot.getOfferingArray())) {
            request.setOfferings((Collection)Sets.newHashSet((Object[])dot.getOfferingArray()));
        }
    }

    private void parseTemporalFilter(DeleteObservationType dot, DeleteObservationRequest request) throws DecodingException {
        if (CollectionHelper.isNotNullOrEmpty((Object[])dot.getTemporalFilterArray())) {
            request.setTemporalFilters(this.parseTemporalFilters(dot.getTemporalFilterArray()));
        }
    }

    private Set<TemporalFilter> parseTemporalFilters(DeleteObservationType.TemporalFilter[] temporalFilters) throws DecodingException {
        HashSet sosTemporalFilters = Sets.newHashSetWithExpectedSize((int)temporalFilters.length);
        for (DeleteObservationType.TemporalFilter temporalFilter : temporalFilters) {
            Object filter = this.decodeXmlElement((XmlObject)temporalFilter.getTemporalOps());
            if (!(filter instanceof TemporalFilter)) continue;
            sosTemporalFilters.add((TemporalFilter)filter);
        }
        return sosTemporalFilters;
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.emptySet();
    }
}

