/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swes.SwesExtension;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwesExtensionEncoderv20
extends AbstractXmlEncoder<XmlObject, SwesExtension<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwesExtensionEncoderv20.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/swes/2.0", (Class[])new Class[]{SwesExtension.class});

    public SwesExtensionEncoderv20() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)ENCODER_KEYS.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    public XmlObject encode(SwesExtension<?> swesExtension, EncodingContext additionalValues) throws EncodingException {
        if (swesExtension == null) {
            throw new UnsupportedEncoderInputException((Encoder)this, "null");
        }
        Object value = swesExtension.getValue();
        if (value == null) {
            throw new UnsupportedEncoderInputException((Encoder)this, "null extension content");
        }
        if (!(value instanceof SweAbstractDataComponent)) {
            throw new UnsupportedEncoderInputException((Encoder)this, value.getClass());
        }
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", value, EncodingContext.of((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }
}

