/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.inject.Inject;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.DecoderRepository;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.NoDecoderForKeyException;
import org.n52.svalbard.util.CodingHelper;

public abstract class AbstractStringRequestDecoder
implements Decoder<OwsServiceCommunicationObject, String> {
    private DecoderRepository decoderRepository;

    @Inject
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setDecoderRepository(DecoderRepository decoderRepository) {
        this.decoderRepository = decoderRepository;
    }

    public OwsServiceCommunicationObject decode(String string) throws DecodingException {
        XmlObject xml = CodingHelper.readXML((String)string);
        DecoderKey key = CodingHelper.getDecoderKey((XmlObject)xml);
        Decoder decoder = this.decoderRepository.getDecoder(key, new DecoderKey[0]);
        if (decoder == null) {
            throw new NoDecoderForKeyException(key);
        }
        return (OwsServiceCommunicationObject)decoder.decode((Object)xml);
    }
}

