/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import java.util.Collections;
import java.util.Set;
import net.opengis.swes.x20.DescribeSensorResponseDocument;
import net.opengis.swes.x20.DescribeSensorResponseType;
import net.opengis.swes.x20.SensorDescriptionType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.sos.SosProcedureDescription;
import org.n52.shetland.ogc.sos.response.DescribeSensorResponse;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractSwesDecoderv20;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.XmlNamespaceDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.w3c.dom.Node;

public class DescribeSensorResponseSwesDocumentDecoder
extends AbstractSwesDecoderv20<DescribeSensorResponse> {
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/swes/2.0", (Class[])new Class[]{DescribeSensorResponseDocument.class})});

    public DescribeSensorResponse decode(XmlObject objectToDecode) throws DecodingException {
        if (objectToDecode instanceof DescribeSensorResponseDocument) {
            DescribeSensorResponse response = new DescribeSensorResponse();
            DescribeSensorResponseDocument dsrd = (DescribeSensorResponseDocument)objectToDecode;
            DescribeSensorResponseType dsrt = dsrd.getDescribeSensorResponse();
            response.setOutputFormat(dsrt.getProcedureDescriptionFormat());
            for (DescribeSensorResponseType.Description description : dsrt.getDescriptionArray()) {
                SensorDescriptionType sdt = description.getSensorDescription();
                try {
                    XmlObject xbProcedureDescription = XmlObject.Factory.parse((Node)this.getNodeFromNodeList(sdt.getData().getDomNode().getChildNodes()));
                    this.checkFormatWithNamespace(dsrt.getProcedureDescriptionFormat(), XmlHelper.getNamespace((XmlObject)xbProcedureDescription));
                    Decoder decoder = this.getDecoder((DecoderKey)new XmlNamespaceDecoderKey(dsrt.getProcedureDescriptionFormat(), xbProcedureDescription.getClass()), new DecoderKey[0]);
                    if (decoder == null) continue;
                    Object decodedProcedureDescription = decoder.decode((Object)xbProcedureDescription);
                    if (decodedProcedureDescription instanceof SosProcedureDescription) {
                        response.addSensorDescription((SosProcedureDescription)decodedProcedureDescription);
                        continue;
                    }
                    if (!(decodedProcedureDescription instanceof AbstractFeature)) continue;
                    response.addSensorDescription(new SosProcedureDescription((AbstractFeature)decodedProcedureDescription));
                }
                catch (XmlException xmle) {
                    throw new DecodingException("Error while parsing procedure description of InsertSensor request!", (Throwable)xmle);
                }
            }
            return response;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)objectToDecode);
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }
}

