/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.isotc211.x2005.gco.CharacterStringPropertyType;
import org.isotc211.x2005.gmd.CIAddressType;
import org.isotc211.x2005.gmd.CIContactPropertyType;
import org.isotc211.x2005.gmd.CIContactType;
import org.isotc211.x2005.gmd.CIOnlineResourceType;
import org.isotc211.x2005.gmd.CIResponsiblePartyDocument;
import org.isotc211.x2005.gmd.CIResponsiblePartyPropertyType;
import org.isotc211.x2005.gmd.CIResponsiblePartyType;
import org.isotc211.x2005.gmd.CITelephoneType;
import org.isotc211.x2005.gmd.LocalisedCharacterStringPropertyType;
import org.isotc211.x2005.gmd.PTFreeTextDocument;
import org.isotc211.x2005.gmd.PTFreeTextPropertyType;
import org.isotc211.x2005.gmd.PTFreeTextType;
import org.n52.shetland.iso.gmd.LocalisedCharacterString;
import org.n52.shetland.iso.gmd.PT_FreeText;
import org.n52.shetland.ogc.sensorML.Role;
import org.n52.shetland.ogc.sensorML.SmlResponsibleParty;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iso19139GmdDecoder
extends AbstractXmlDecoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Iso19139GmdDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.isotc211.org/2005/gmd", (Class[])new Class[]{CIResponsiblePartyDocument.class, CIResponsiblePartyPropertyType.class, CIResponsiblePartyType.class});

    public Iso19139GmdDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Object decode(XmlObject element) throws DecodingException {
        if (element instanceof CIResponsiblePartyDocument) {
            return this.decodeCIResponsibleParty(((CIResponsiblePartyDocument)element).getCIResponsibleParty());
        }
        if (element instanceof CIResponsiblePartyPropertyType) {
            return this.decodeCIResponsiblePartyPropertyType((CIResponsiblePartyPropertyType)element);
        }
        if (element instanceof CIResponsiblePartyType) {
            return this.decodeCIResponsibleParty((CIResponsiblePartyType)element);
        }
        if (element instanceof PTFreeTextDocument) {
            return this.decodePTFreeTextType(((PTFreeTextDocument)element).getPTFreeText());
        }
        if (element instanceof PTFreeTextPropertyType) {
            return this.decodePTFreeTextType(((PTFreeTextPropertyType)element).getPTFreeText());
        }
        if (element instanceof PTFreeTextType) {
            return this.decodePTFreeTextType((PTFreeTextType)element);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, element);
    }

    private PT_FreeText decodePTFreeTextType(PTFreeTextType ptftt) {
        PT_FreeText ptFreeText = new PT_FreeText();
        for (LocalisedCharacterStringPropertyType lcspt : ptftt.getTextGroupArray()) {
            ptFreeText.addTextGroup(new LocalisedCharacterString(lcspt.getLocalisedCharacterString().getStringValue()));
        }
        return ptFreeText;
    }

    private Object decodeCIResponsiblePartyPropertyType(CIResponsiblePartyPropertyType element) throws DecodingException {
        if (element.isSetCIResponsibleParty()) {
            return this.decodeCIResponsibleParty(element.getCIResponsibleParty());
        }
        if (element.isSetHref()) {
            SmlResponsibleParty responsibleParty = new SmlResponsibleParty();
            responsibleParty.setHref(element.getHref());
            if (element.isSetTitle()) {
                responsibleParty.setTitle(element.getTitle());
            }
            if (element.isSetRole()) {
                responsibleParty.setRole(element.getRole());
            }
            return responsibleParty;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)element);
    }

    private Object decodeCIResponsibleParty(CIResponsiblePartyType element) throws DecodingException {
        Object decodeXmlElement;
        SmlResponsibleParty responsibleParty = new SmlResponsibleParty();
        if (element.isSetIndividualName()) {
            responsibleParty.setIndividualName(element.getIndividualName().getCharacterString());
        }
        if (element.isSetOrganisationName()) {
            responsibleParty.setOrganizationName(element.getOrganisationName().getCharacterString());
        }
        if (element.isSetPositionName()) {
            responsibleParty.setPositionName(element.getPositionName().getCharacterString());
        }
        if (element.isSetContactInfo()) {
            this.decodeContactInfo(element.getContactInfo(), responsibleParty);
        }
        if (element.getRole().isSetCIRoleCode() && (decodeXmlElement = this.decodeXmlElement((XmlObject)element.getRole().getCIRoleCode())) instanceof Role) {
            responsibleParty.setRole((Role)decodeXmlElement);
        }
        return responsibleParty;
    }

    private void decodeContactInfo(CIContactPropertyType cicpt, SmlResponsibleParty responsibleParty) {
        if (cicpt.isSetCIContact()) {
            this.decodeContact(cicpt.getCIContact(), responsibleParty);
        }
    }

    private void decodeContact(CIContactType cic, SmlResponsibleParty responsibleParty) {
        if (cic.isSetAddress()) {
            this.decodeCiAddress(cic.getAddress().getCIAddress(), responsibleParty);
        }
        if (cic.isSetContactInstructions()) {
            responsibleParty.setContactInstructions(cic.getContactInstructions().getCharacterString());
        }
        if (cic.isSetHoursOfService()) {
            responsibleParty.setHoursOfService(cic.getHoursOfService().getCharacterString());
        }
        if (cic.isSetOnlineResource() && cic.getOnlineResource().isSetHref()) {
            responsibleParty.setOnlineResource((Collection)Lists.newArrayList((Object[])new String[]{cic.getOnlineResource().getHref()}));
        }
        if (cic.isSetPhone() && cic.getPhone().isSetCITelephone()) {
            this.decodePhone(cic.getPhone().getCITelephone(), responsibleParty);
        }
    }

    private void decodeCiAddress(CIAddressType ciat, SmlResponsibleParty responsibleParty) {
        if (ciat.isSetAdministrativeArea()) {
            responsibleParty.setAdministrativeArea(ciat.getAdministrativeArea().getCharacterString());
        }
        if (ciat.isSetCity()) {
            responsibleParty.setCity(ciat.getCity().getCharacterString());
        }
        if (ciat.isSetCountry()) {
            responsibleParty.setCountry(ciat.getCountry().getCharacterString());
        }
        if (ciat.isSetPostalCode()) {
            responsibleParty.setPostalCode(ciat.getPostalCode().getCharacterString());
        }
    }

    private void decodeOnlineResource(CIOnlineResourceType ciort, SmlResponsibleParty responsibleParty) {
    }

    private void decodePhone(CITelephoneType citt, SmlResponsibleParty responsibleParty) {
        if (CollectionHelper.isNotNullOrEmpty((Object[])citt.getVoiceArray())) {
            responsibleParty.setPhoneVoice(this.characterStringPropertyTypeArrayToList(citt.getVoiceArray()));
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])citt.getFacsimileArray())) {
            responsibleParty.setPhoneFax(this.characterStringPropertyTypeArrayToList(citt.getFacsimileArray()));
        }
    }

    private List<String> characterStringPropertyTypeArrayToList(CharacterStringPropertyType[] array) {
        ArrayList values = Lists.newArrayList();
        for (CharacterStringPropertyType cspt : array) {
            values.add(cspt.getCharacterString());
        }
        return values;
    }
}

