/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.n52.shetland.ogc.ows.extension.Extension;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swes.SwesExtension;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.SwesDecoderv20;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SwesExtensionDecoderv20
extends AbstractXmlDecoder<XmlObject, Extension<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwesDecoderv20.class);
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.w3.org/2001/XMLSchema", (Class[])new Class[]{XmlAnyTypeImpl.class}), CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/swes/2.0", (Class[])new Class[]{XmlAnyTypeImpl.class})});

    public SwesExtensionDecoderv20() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Extension<?> decode(XmlObject xmlObject) throws DecodingException, UnsupportedDecoderInputException {
        XmlObject[] children;
        if (this.isSwesExtension(xmlObject) && (children = xmlObject.selectPath("./*")).length == 1) {
            Object xmlObj = this.decodeXmlElement(children[0]);
            if (xmlObj instanceof Extension) {
                return (Extension)xmlObj;
            }
            SwesExtension extension = new SwesExtension();
            extension.setValue(xmlObj);
            if (this.isSweAbstractDataComponent(xmlObj)) {
                extension.setDefinition(((SweAbstractDataComponent)xmlObj).getDefinition());
            }
            return extension;
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, xmlObject);
    }

    private boolean isSweAbstractDataComponent(Object xmlObj) {
        return xmlObj instanceof SweAbstractDataComponent && ((SweAbstractDataComponent)xmlObj).isSetDefinition();
    }

    private boolean isSwesExtension(XmlObject xmlObject) {
        Node node = xmlObject.getDomNode();
        return node.getNamespaceURI().equalsIgnoreCase("http://www.opengis.net/swes/2.0") && node.getLocalName().equalsIgnoreCase("extension");
    }
}

