/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.opengis.samplingSpatial.x20.SFSpatialSamplingFeatureType;
import net.opengis.waterml.x20.MonitoringPointDocument;
import net.opengis.waterml.x20.MonitoringPointPropertyType;
import net.opengis.waterml.x20.MonitoringPointType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.om.features.samplingFeatures.AbstractSamplingFeature;
import org.n52.shetland.ogc.om.series.wml.WmlMonitoringPoint;
import org.n52.shetland.ogc.sos.FeatureType;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.SamplingDecoderv20;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmlMonitoringPointDecoderv20
extends SamplingDecoderv20 {
    private static final Logger LOGGER = LoggerFactory.getLogger(WmlMonitoringPointDecoderv20.class);
    private static final Set<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)new FeatureType("http://www.opengis.net/def/nil/OGC/0/unknown")).add((Object)new FeatureType("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingPoint")).add((Object)new FeatureType("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingCurve")).add((Object)new FeatureType("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface")).build();
    private static final Set<String> CONFORMANCE_CLASSES = Sets.newHashSet((Object[])new String[]{"http://www.opengis.net/spec/OMXML/2.0/conf/spatialSampling", "http://www.opengis.net/spec/OMXML/2.0/conf/samplingPoint", "http://www.opengis.net/spec/OMXML/2.0/conf/samplingCurve", "http://www.opengis.net/spec/OMXML/2.0/conf/samplingSurface"});
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/waterml/2.0", (Class[])new Class[]{MonitoringPointDocument.class, MonitoringPointPropertyType.class, MonitoringPointType.class})});

    public WmlMonitoringPointDecoderv20() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    @Override
    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    @Override
    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    @Override
    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    @Override
    public AbstractFeature decode(XmlObject element) throws DecodingException {
        XmlHelper.validateDocument((XmlObject)element);
        if (element instanceof MonitoringPointDocument) {
            return this.decode((XmlObject)((MonitoringPointDocument)element).getMonitoringPoint());
        }
        if (element instanceof MonitoringPointPropertyType) {
            if (((MonitoringPointPropertyType)element).getMonitoringPoint() != null) {
                return this.decode((XmlObject)((MonitoringPointPropertyType)element).getMonitoringPoint());
            }
            return this.parseMonitoringPointPropertyType((MonitoringPointPropertyType)element);
        }
        if (element instanceof MonitoringPointType) {
            return this.parseMonitoringPoint((MonitoringPointType)element);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, element);
    }

    private AbstractFeature parseMonitoringPoint(MonitoringPointType mpt) throws DecodingException {
        WmlMonitoringPoint monitoingPoint = new WmlMonitoringPoint(null, mpt.getId());
        return this.parseSpatialSamplingFeature((SFSpatialSamplingFeatureType)mpt, (AbstractSamplingFeature)monitoingPoint);
    }

    private AbstractFeature parseMonitoringPointPropertyType(MonitoringPointPropertyType element) {
        return null;
    }
}

