/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.xmlbeans.XmlObject;
import org.n52.faroe.ConfigurationError;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.shetland.aqd.AbstractEReportingHeader;
import org.n52.shetland.aqd.AqdConstants;
import org.n52.shetland.aqd.EReportObligationRepository;
import org.n52.shetland.aqd.EReportingHeader;
import org.n52.shetland.aqd.ReportObligationType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractResponseEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.OperationResponseEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;

@Configurable
public abstract class AbstractAqdResponseEncoder<T extends OwsServiceResponse>
extends AbstractResponseEncoder<T> {
    private Optional<EReportObligationRepository> reportObligationRepository;
    private String namespace;
    private String observationPrefix;

    public AbstractAqdResponseEncoder(String operation, Class<T> responseType) {
        super("AQD", "1.0.0", operation, "http://dd.eionet.europa.eu/schemaset/id2011850eu-1.0", "aqd", responseType);
    }

    @Inject
    public void setReportObligationRepository(Optional<EReportObligationRepository> reportObligationRepository) {
        this.reportObligationRepository = reportObligationRepository;
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{AqdConstants.NS_AQD_SCHEMA_LOCATION});
    }

    protected void processObservation(OmObservation observation, TimePeriod timePeriod, TimeInstant resultTime, FeatureCollection featureCollection, AbstractEReportingHeader eReportingHeader, int counter) {
        if (observation.isSetPhenomenonTime()) {
            observation.setGmlId(this.getObservationId(counter));
            eReportingHeader.addContent((AbstractFeature)new OmObservation().setIdentifier(new CodeWithAuthority(this.getObservationXlink(observation.getGmlId()))));
            timePeriod.extendToContain(observation.getPhenomenonTime());
            observation.setResultTime(resultTime);
            featureCollection.addMember((AbstractFeature)observation);
        }
    }

    protected String getObservationXlink(String gmlId) {
        StringBuilder id = new StringBuilder();
        if (this.isSetEReportingNamespace()) {
            id.append(this.getEReportingNamespace());
            if (!this.getEReportingNamespace().endsWith("/")) {
                id.append("/");
            }
        } else {
            id.append("#");
        }
        id.append(gmlId);
        return id.toString();
    }

    protected String getObservationId(int counter) {
        return (this.isSetEReportingObservationPrefix() ? this.getEReportingObservationPrefix() : "o_").concat(Integer.toString(counter));
    }

    public String getEReportingNamespace() {
        return this.namespace;
    }

    @Setting(value="eReporting.namespace", required=false)
    public void setEReportingNamespace(String namespace) throws ConfigurationError {
        this.namespace = namespace;
    }

    protected boolean isSetEReportingNamespace() {
        return !Strings.isNullOrEmpty((String)this.getEReportingNamespace());
    }

    @Setting(value="eReporting.observation.prefix", required=false)
    public void setEReportingObservationPrefix(String observationPrefix) throws ConfigurationError {
        this.observationPrefix = observationPrefix;
    }

    protected String getEReportingObservationPrefix() {
        return this.observationPrefix;
    }

    protected boolean isSetEReportingObservationPrefix() {
        return !Strings.isNullOrEmpty((String)this.getEReportingObservationPrefix());
    }

    protected EReportingHeader getEReportingHeader(ReportObligationType type) throws OwsExceptionReport, EncodingException {
        if (this.reportObligationRepository.isPresent()) {
            return this.reportObligationRepository.get().createHeader(type);
        }
        throw new EncodingException("Missing implementatation of %s!", new Object[]{EReportObligationRepository.class});
    }

    protected XmlObject encodeGml(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o);
    }

    protected XmlObject encodeGml(EncodingContext context, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o, context);
    }

    protected XmlObject encodeOws(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/ows/1.1", o);
    }

    protected XmlObject encodeOws(EncodingContext context, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/ows/1.1", o, context);
    }

    protected XmlObject encodeFes(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/fes/2.0", o);
    }

    protected XmlObject encodeFes(EncodingContext context, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/fes/2.0", o, context);
    }

    protected XmlObject encodeSwe(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o);
    }

    protected XmlObject encodeSwe(EncodingContext context, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o, context);
    }

    protected OwsServiceResponse changeResponseServiceVersion(OwsServiceResponse response) {
        response.setService("SOS");
        response.setVersion("2.0.0");
        return response;
    }

    protected Encoder<Object, OwsServiceResponse> getEncoder(OwsServiceResponse asr) {
        OperationResponseEncoderKey key = new OperationResponseEncoderKey(new OwsOperationKey((OwsServiceCommunicationObject)asr), this.getContentType());
        Encoder encoder = this.getEncoder((EncoderKey)key, new EncoderKey[0]);
        if (encoder == null) {
            throw new RuntimeException((Throwable)new NoEncoderForKeyException((Object)key));
        }
        return encoder;
    }

    protected XmlObject encodeWithSosEncoder(T response) throws EncodingException {
        Object encode;
        Encoder<Object, OwsServiceResponse> encoder = this.getEncoder(this.changeResponseServiceVersion((OwsServiceResponse)response));
        if (encoder != null && (encode = encoder.encode(response)) != null && encode instanceof XmlObject) {
            return (XmlObject)encode;
        }
        return null;
    }
}

