/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import eu.europa.ec.inspire.schemas.base.x33.IdentifierType;
import java.util.Map;
import java.util.Set;
import org.n52.shetland.inspire.base.Identifier;
import org.n52.shetland.inspire.base.InspireBaseConstants;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractXmlEncoder;

public abstract class AbstractIdentifierEncoder<T>
extends AbstractXmlEncoder<T, Identifier> {
    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/base/3.3", "base");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{InspireBaseConstants.BASE_33_SCHEMA_LOCATION});
    }

    protected IdentifierType createIdentifierType(Identifier identifier) {
        IdentifierType it = IdentifierType.Factory.newInstance();
        return this.encodeIdentifierType(it, identifier);
    }

    protected IdentifierType encodeIdentifierType(IdentifierType it, Identifier identifier) {
        it.setLocalId(identifier.getLocalId());
        it.setNamespace(identifier.getNamespace());
        if (identifier.getVersionId().isPresent()) {
            it.addNewVersionId().setStringValue((String)identifier.getVersionId().get());
        } else if (identifier.getVersionId().isNil()) {
            IdentifierType.VersionId vid = it.addNewVersionId();
            vid.setNil();
            if (identifier.getVersionId().hasReason()) {
                vid.setNilReason(identifier.getVersionId().getNilReason().get());
            }
        }
        return it;
    }
}

