/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.util.Set;
import net.opengis.swes.x20.ExtensibleRequestType;
import org.n52.shetland.ogc.ows.extension.Extension;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.swes.SwesConstants;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractRequestEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;

public abstract class AbstractSwesRequestEncoder<T extends OwsServiceRequest>
extends AbstractRequestEncoder<T> {
    public AbstractSwesRequestEncoder(String operation, Class<T> responseType) {
        super("SOS", "2.0.0", operation, "http://www.opengis.net/swes/2.0", "swes", responseType);
    }

    protected void addExtension(OwsServiceRequest request, ExtensibleRequestType extensibleRequestType) throws EncodingException {
        if (request.hasExtensions()) {
            for (Extension extension : request.getExtensions().getExtensions()) {
                extensibleRequestType.addNewExtension().set(this.encodeObjectToXml(extension.getNamespace(), extension));
            }
        }
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations() {
        return CollectionHelper.set((Object[])new SchemaLocation[]{SwesConstants.SWES_20_SCHEMA_LOCATION});
    }

    protected void validateInput(T request) throws UnsupportedEncoderInputException {
        if (request == null) {
            throw new UnsupportedEncoderInputException((Encoder)this, "null");
        }
        if (!request.isSetService()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "missing service");
        }
        if (!request.isSetVersion()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "missing version");
        }
    }
}

