/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.ConformanceClass;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.SchemaRepository;
import org.n52.svalbard.encode.StreamingEncoder;
import org.n52.svalbard.encode.StreamingEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.N52XmlHelper;
import org.n52.svalbard.util.XmlHelper;

@Configurable
public abstract class AbstractXmlResponseEncoder<T>
extends AbstractXmlEncoder<XmlObject, T>
implements StreamingEncoder<XmlObject, T>,
ConformanceClass {
    private final String namespace;
    private final String prefix;
    private final Class<T> responseType;
    private boolean validate;
    private SchemaRepository schemaRepository;

    public AbstractXmlResponseEncoder(String service, String version, String operation, String namespace, String prefix, Class<T> responseType, boolean validate) {
        this.namespace = namespace;
        this.prefix = prefix;
        this.responseType = responseType;
        this.validate = validate;
    }

    public AbstractXmlResponseEncoder(String service, String version, String operation, String namespace, String prefix, Class<T> responseType) {
        this(service, version, operation, namespace, prefix, responseType, false);
    }

    @Inject
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setSchemaRepository(SchemaRepository schemaRepository) {
        this.schemaRepository = schemaRepository;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public SchemaRepository getSchemaRepository() {
        return this.schemaRepository;
    }

    @Setting(value="service.response.validate", required=false)
    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        if (nameSpacePrefixMap != null) {
            nameSpacePrefixMap.put(this.namespace, this.prefix);
        }
    }

    @Override
    public XmlObject encode(T response) throws EncodingException {
        if (response == null) {
            throw new UnsupportedEncoderInputException((Encoder)this, (String)null);
        }
        return this.encode(response, EncodingContext.empty());
    }

    public XmlObject encode(T response, EncodingContext additionalValues) throws EncodingException {
        if (response == null) {
            throw new UnsupportedEncoderInputException((Encoder)this, (String)null);
        }
        XmlObject xml = this.create(response);
        this.setSchemaLocations(xml);
        if (this.validate) {
            XmlHelper.validateDocument((XmlObject)xml, EncodingException::new);
        }
        return xml;
    }

    private void setSchemaLocations(XmlObject document) {
        Map schemaLocations = this.getSchemaLocations(document).collect(Collectors.toMap(SchemaLocation::getNamespace, Function.identity()));
        schemaLocations.putAll(this.getSchemaLocations().stream().collect(Collectors.toMap(SchemaLocation::getNamespace, Function.identity())));
        schemaLocations.putAll(this.getConcreteSchemaLocations(XmlHelper.getNamespace((XmlObject)document)).stream().collect(Collectors.toMap(SchemaLocation::getNamespace, Function.identity())));
        N52XmlHelper.setSchemaLocationsToDocument((XmlObject)document, schemaLocations.values());
    }

    private Stream<SchemaLocation> getSchemaLocations(XmlObject document) {
        return N52XmlHelper.getNamespaces((XmlObject)document).stream().map(arg_0 -> ((SchemaRepository)this.schemaRepository).getSchemaLocation(arg_0)).filter(Objects::nonNull).flatMap(Collection::stream);
    }

    protected abstract Set<SchemaLocation> getConcreteSchemaLocations();

    protected Set<SchemaLocation> getConcreteSchemaLocations(String namespace) {
        return this.getConcreteSchemaLocations();
    }

    protected abstract XmlObject create(T var1) throws EncodingException;

    protected void create(T response, OutputStream outputStream, EncodingContext encodingValues) throws EncodingException {
        try {
            XmlOptions xmlOptions;
            if (encodingValues.has((Enum)StreamingEncoderFlags.EMBEDDED)) {
                xmlOptions = new XmlOptions(this.getXmlOptions());
                xmlOptions.setSaveNoXmlDecl();
            } else {
                xmlOptions = this.getXmlOptions();
            }
            XmlObject xmlObject = this.create(response);
            this.setSchemaLocations(xmlObject);
            xmlObject.save(outputStream, xmlOptions);
        }
        catch (IOException ioe) {
            throw new EncodingException("Error while writing element to stream!", (Throwable)ioe);
        }
    }

    protected Class<T> getResponseType() {
        return this.responseType;
    }
}

