/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.opengis.gwmlWell.x22.GWGeologyLogType;
import net.opengis.om.x20.OMObservationType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gwml.GWMLConstants;
import org.n52.shetland.ogc.om.ObservationType;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.values.ProfileValue;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.OmEncoderv20;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.CodingHelper;

public class GWGeologyLogObservationTypeEncoder
extends OmEncoderv20 {
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/gwml/2.2", (Class[])new Class[]{OmObservation.class}), CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/gwml-well/2.2", (Class[])new Class[]{OmObservation.class})});
    private static final Set<SupportedType> SUPPORTED_TYPES = Sets.newHashSet((Object[])new SupportedType[]{new ObservationType("http://www.opengis.net/def/observationType/OGC-GWML/2.2/GW_GeologyLog"), new ObservationType("http://www.opengis.net/def/observationType/OGC-GWML/2.2/GW_GeologyLog"), new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CategoryObservation"), new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TextObservation"), new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_ProfileObservation")});
    private static final Map<String, Map<String, Set<String>>> SUPPORTED_RESPONSE_FORMATS = Collections.singletonMap("SOS", Collections.singletonMap("2.0.0", Collections.singleton("http://www.opengis.net/gwml/2.2")));

    @Override
    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    @Override
    public Map<String, Set<SupportedType>> getSupportedResponseFormatObservationTypes() {
        return Collections.singletonMap("http://www.opengis.net/gwml/2.2", this.getSupportedTypes());
    }

    @Override
    public boolean isObservationAndMeasurmentV20Type() {
        return true;
    }

    @Override
    protected XmlObject createResult(OmObservation sosObservation) throws EncodingException {
        return super.createResult(sosObservation);
    }

    @Override
    public boolean shouldObservationsWithSameXBeMerged() {
        return false;
    }

    @Override
    public boolean supportsResultStreamingForMergedValues() {
        return false;
    }

    @Override
    public Set<String> getSupportedResponseFormats(String service, String version) {
        if (SUPPORTED_RESPONSE_FORMATS.get(service) != null && SUPPORTED_RESPONSE_FORMATS.get(service).get(version) != null) {
            return SUPPORTED_RESPONSE_FORMATS.get(service).get(version);
        }
        return new HashSet<String>(0);
    }

    @Override
    public String getDefaultFeatureEncodingNamespace() {
        return super.getDefaultFeatureEncodingNamespace();
    }

    @Override
    protected String getDefaultProcedureEncodingNamspace() {
        return super.getDefaultProcedureEncodingNamspace();
    }

    @Override
    protected boolean convertEncodedProcedure() {
        return false;
    }

    @Override
    protected OMObservationType createOmObservationType() {
        return GWGeologyLogType.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    @Override
    protected void addObservationType(OMObservationType xbObservation, String observationType) {
        xbObservation.addNewType().setHref("http://www.opengis.net/def/observationType/OGC-GWML/2.2/GW_GeologyLog");
    }

    @Override
    protected void addAddtitionalInformation(OMObservationType omot, OmObservation observation) throws EncodingException {
        if (omot instanceof GWGeologyLogType && observation.getValue().getValue() instanceof ProfileValue) {
            ProfileValue value = (ProfileValue)observation.getValue().getValue();
            if (value.isSetFromLevel()) {
                this.encodeStartDepth(((GWGeologyLogType)omot).addNewStartDepth(), (SweQuantity)value.getFromLevel());
            }
            if (value.isSetToLevel()) {
                this.encodeEndDepth(((GWGeologyLogType)omot).addNewEndDepth(), (SweQuantity)value.getToLevel());
            }
        }
    }

    @Override
    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/gwml/2.2", "gwml2");
        nameSpacePrefixMap.put("http://www.opengis.net/gwml-well/2.2", "gwml2w");
    }

    @Override
    public Set<SchemaLocation> getSchemaLocations() {
        HashSet schemaLocations = Sets.newHashSet((Object[])new SchemaLocation[]{GWMLConstants.GWML_22_SCHEMA_LOCATION, GWMLConstants.GWML_WELL_22_SCHEMA_LOCATION});
        schemaLocations.addAll(super.getSchemaLocations());
        return schemaLocations;
    }

    private void encodeStartDepth(GWGeologyLogType.StartDepth sd, SweQuantity sweQuantity) throws EncodingException {
        sd.addNewQuantity().set(this.encodeSweCommon(sweQuantity));
    }

    private void encodeEndDepth(GWGeologyLogType.EndDepth ed, SweQuantity sweQuantity) throws EncodingException {
        ed.addNewQuantity().set(this.encodeSweCommon(sweQuantity));
    }
}

