/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import net.opengis.swes.x20.ExtensibleRequestType;
import net.opengis.swes.x20.InsertSensorDocument;
import net.opengis.swes.x20.InsertSensorType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosProcedureDescriptionUnknownType;
import org.n52.shetland.ogc.sos.request.InsertSensorRequest;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.encode.AbstractSwesRequestEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.XmlHelper;

public class InsertSensorRequestEncoder
extends AbstractSwesRequestEncoder<InsertSensorRequest> {
    public InsertSensorRequestEncoder() {
        super(Sos2Constants.Operations.InsertSensor.name(), InsertSensorRequest.class);
    }

    @Override
    protected XmlObject create(InsertSensorRequest request) throws EncodingException {
        this.validateInput(request);
        InsertSensorDocument doc = InsertSensorDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        InsertSensorType insertSensor = doc.addNewInsertSensor();
        this.addVersion(insertSensor);
        this.addService(insertSensor);
        this.addProcedureDescriptionFormat(request, insertSensor);
        this.addProcedureDescription(request, insertSensor);
        this.addObservableProperties(request, insertSensor);
        this.addMetadata(request, insertSensor);
        this.addExtension((OwsServiceRequest)request, (ExtensibleRequestType)insertSensor);
        return doc;
    }

    @Override
    protected void validateInput(InsertSensorRequest request) throws UnsupportedEncoderInputException {
        super.validateInput(request);
        if (!request.isSetProcedureDescriptionFormat()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "procedure description format missing");
        }
        if (!request.isSetProcedureDescription()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "procedure description missing");
        }
        if (!request.isSetObservableProperty()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "observed property missing");
        }
        if (!request.isSetMetadata()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "metadata field missing");
        }
    }

    private void addProcedureDescription(InsertSensorRequest request, InsertSensorType insertSensor) throws EncodingException {
        XmlObject xmlObj;
        if (request.getProcedureDescription() instanceof SosProcedureDescriptionUnknownType && request.getProcedureDescription().isSetXml()) {
            try {
                xmlObj = XmlHelper.parseXmlString((String)request.getProcedureDescription().getXml());
            }
            catch (DecodingException de) {
                throw new EncodingException("An xml error occured when parsing the request!", (Throwable)de);
            }
        }
        xmlObj = this.encodeObjectToXml(request.getProcedureDescriptionFormat(), request.getProcedureDescription().getProcedureDescription());
        insertSensor.addNewProcedureDescription().set(xmlObj);
    }

    private void addMetadata(InsertSensorRequest request, InsertSensorType insertSensor) throws EncodingException {
        XmlObject encodedMetadata = this.encodeObjectToXmlPropertyType("http://www.opengis.net/sos/2.0", request.getMetadata());
        insertSensor.addNewMetadata().addNewInsertionMetadata().set(encodedMetadata);
    }

    private void addObservableProperties(InsertSensorRequest request, InsertSensorType insertSensor) {
        request.getObservableProperty().stream().forEach(c -> insertSensor.addNewObservableProperty().setStringValue(c));
    }

    private void addProcedureDescriptionFormat(InsertSensorRequest request, InsertSensorType insertSensor) {
        insertSensor.setProcedureDescriptionFormat(request.getProcedureDescriptionFormat());
    }

    private void addService(InsertSensorType insertSensor) {
        insertSensor.setService("SOS");
    }

    private void addVersion(InsertSensorType insertSensor) {
        insertSensor.setVersion("2.0.0");
    }
}

