/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import eu.europa.ec.inspire.schemas.ompr.x30.ProcessParameterType;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.inspire.ompr.InspireOMPRConstants;
import org.n52.shetland.inspire.ompr.ProcessParameter;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.ClassToClassEncoderKey;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlDocumentEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessParameterTypeEncoder
extends AbstractXmlEncoder<XmlObject, ProcessParameter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessParameterTypeEncoder.class);
    private static final Set<EncoderKey> ENCODER_KEYS = Sets.newHashSet((Object[])new EncoderKey[]{new ClassToClassEncoderKey(ProcessParameterType.class, ProcessParameter.class), new XmlDocumentEncoderKey("http://inspire.ec.europa.eu/schemas/ompr/3.0", ProcessParameter.class)});

    public ProcessParameterTypeEncoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.emptySet();
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/ompr/3.0", "ompr");
    }

    @Override
    public MediaType getContentType() {
        return InspireOMPRConstants.OMPR_30_CONTENT_TYPE;
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{InspireOMPRConstants.OMPR_SCHEMA_LOCATION});
    }

    @Override
    public XmlObject encode(ProcessParameter processParameter) throws EncodingException {
        return this.encode(processParameter, EncodingContext.empty());
    }

    public XmlObject encode(ProcessParameter processParameter, EncodingContext context) throws EncodingException {
        return this.createProcessParameter(processParameter);
    }

    protected ProcessParameterType createProcessParameter(ProcessParameter processParameter) throws EncodingException {
        ProcessParameterType ppt = ProcessParameterType.Factory.newInstance();
        ppt.addNewName().set(this.encodeObjectToXml("http://www.opengis.net/gml/3.2", processParameter.getName()));
        if (processParameter.isSetDescription()) {
            ppt.setDescription(processParameter.getDescription());
        }
        return ppt;
    }
}

