/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.SessionImpl;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.OuterJoinLoadable;

public final class DataModelUtil {
    public static boolean isNamedQuerySupported(String namedQuery, Session session) {
        NamedQueryDefinition namedQueryDef = ((SessionImpl)session).getSessionFactory().getNamedQuery(namedQuery);
        NamedSQLQueryDefinition namedSQLQueryDef = ((SessionImpl)session).getSessionFactory().getNamedSQLQuery(namedQuery);
        return namedQueryDef != null || namedSQLQueryDef != null;
    }

    public static String getSqlString(Criteria criteria) {
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        SessionImplementor session = criteriaImpl.getSession();
        SessionFactoryImplementor factory = DataModelUtil.extractSessionFactory(criteria);
        CriteriaQueryTranslator translator = new CriteriaQueryTranslator(factory, criteriaImpl, criteriaImpl.getEntityOrClassName(), "this_");
        String[] implementors = factory.getImplementors(criteriaImpl.getEntityOrClassName());
        OuterJoinLoadable joinLoader = (OuterJoinLoadable)factory.getEntityPersister(implementors[0]);
        CriteriaJoinWalker walker = new CriteriaJoinWalker(joinLoader, translator, factory, criteriaImpl, criteriaImpl.getEntityOrClassName(), session.getLoadQueryInfluencers());
        return walker.getSQLString();
    }

    public static boolean isEntitySupported(Class<?> clazz, Criteria criteria) {
        SessionFactoryImplementor factory = DataModelUtil.extractSessionFactory(criteria);
        if (factory != null) {
            return factory.getAllClassMetadata().keySet().contains(clazz.getName());
        }
        return false;
    }

    public static SessionFactoryImplementor extractSessionFactory(Criteria criteria) {
        SessionImplementor session = DataModelUtil.getSessionImplementor(criteria);
        return session != null ? session.getFactory() : null;
    }

    private static SessionImplementor getSessionImplementor(Criteria criteria) {
        SessionImplementor session = null;
        if (criteria instanceof CriteriaImpl) {
            session = ((CriteriaImpl)criteria).getSession();
        } else if (criteria instanceof CriteriaImpl.Subcriteria) {
            CriteriaImpl temp = (CriteriaImpl)((CriteriaImpl.Subcriteria)criteria).getParent();
            session = temp.getSession();
        }
        return session;
    }
}

