/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.UnitEntity;

public class DatasetEntity<T extends DataEntity<?>>
extends DescribableEntity {
    public static final String ENTITY_ALIAS = "dataset";
    public static final String PROPERTY_PROCEDURE = "procedure";
    public static final String PROPERTY_CATEGORY = "category";
    public static final String PROPERTY_PHENOMENON = "phenomenon";
    public static final String PROPERTY_FEATURE = "feature";
    public static final String PROPERTY_OFFERING = "offering";
    public static final String PROPERTY_PLATFORM = "platform";
    public static final String PROPERTY_VALUE_TYPE = "valueType";
    public static final String PROPERTY_OBSERVATION_TYPE = "observationType";
    private CategoryEntity category;
    private PhenomenonEntity phenomenon;
    private ProcedureEntity procedure;
    private OfferingEntity offering;
    private FeatureEntity feature;
    private PlatformEntity platform;
    private Boolean published = Boolean.TRUE;
    private Boolean deleted = Boolean.FALSE;
    private List<T> observations = new ArrayList<T>();
    private String valueType;
    private Set<Date> resultTimes;
    @Deprecated
    private T firstValue;
    @Deprecated
    private T lastValue;
    private Date firstValueAt;
    private Date lastValueAt;
    private UnitEntity unit;
    private long observationCount = -1L;

    public DatasetEntity() {
        this(null);
    }

    public DatasetEntity(String type) {
        this.valueType = type;
    }

    public CategoryEntity getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEntity category) {
        this.category = category;
    }

    public PhenomenonEntity getPhenomenon() {
        return this.phenomenon;
    }

    public void setPhenomenon(PhenomenonEntity phenomenon) {
        this.phenomenon = phenomenon;
    }

    public ProcedureEntity getProcedure() {
        return this.procedure;
    }

    public void setProcedure(ProcedureEntity procedure) {
        this.procedure = procedure;
    }

    public OfferingEntity getOffering() {
        return this.offering;
    }

    public void setOffering(OfferingEntity offering) {
        this.offering = offering;
    }

    public FeatureEntity getFeature() {
        return this.feature;
    }

    public void setFeature(FeatureEntity feature) {
        this.feature = feature;
    }

    public PlatformEntity getPlatform() {
        return this.platform;
    }

    public void setPlatform(PlatformEntity platform) {
        this.platform = platform;
    }

    public List<T> getObservations() {
        return this.observations;
    }

    public void setObservations(List<T> observations) {
        this.observations = observations;
    }

    public Boolean isPublished() {
        return this.published;
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Deprecated
    public T getFirstValue() {
        return this.firstValue;
    }

    @Deprecated
    public void setFirstValue(T firstValue) {
        this.firstValue = firstValue;
    }

    @Deprecated
    public T getLastValue() {
        return this.lastValue;
    }

    @Deprecated
    public void setLastValue(T lastValue) {
        this.lastValue = lastValue;
    }

    public Date getFirstValueAt() {
        return this.firstValueAt != null ? new Timestamp(this.firstValueAt.getTime()) : null;
    }

    public void setFirstValueAt(Date firstValueAt) {
        this.firstValueAt = firstValueAt != null ? new Timestamp(firstValueAt.getTime()) : null;
    }

    public Date getLastValueAt() {
        return this.lastValueAt != null ? new Timestamp(this.lastValueAt.getTime()) : null;
    }

    public void setLastValueAt(Date lastValueAt) {
        this.lastValueAt = lastValueAt != null ? new Timestamp(lastValueAt.getTime()) : null;
    }

    public String getValueType() {
        return this.valueType == null || this.valueType.isEmpty() ? "quantity" : this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public Set<Date> getResultTimes() {
        Set<Date> unmodifiableResultTimes = this.wrapToUnmutables(this.resultTimes);
        return unmodifiableResultTimes != null ? Collections.unmodifiableSet(unmodifiableResultTimes) : null;
    }

    public void setResultTimes(Set<Date> resultTimes) {
        this.resultTimes = this.wrapToUnmutables(resultTimes);
    }

    private Set<Date> wrapToUnmutables(Set<Date> dates) {
        return dates != null ? dates.stream().map(d -> d != null ? new Timestamp(d.getTime()) : null).collect(Collectors.toSet()) : null;
    }

    public UnitEntity getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEntity unit) {
        this.unit = unit;
    }

    public boolean hasUnit() {
        return this.unit != null;
    }

    public String getUnitI18nName(String locale) {
        String name = null;
        if (this.unit != null) {
            name = this.unit.getNameI18n(locale);
        }
        return name;
    }

    public void setObservationCount(long count) {
        this.observationCount = count;
    }

    public long getObservationCount() {
        return this.observationCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [");
        sb.append(" id: ").append(this.getPkid());
        sb.append(" , category: ").append(this.category);
        sb.append(" , phenomenon: ").append(this.phenomenon);
        sb.append(" , procedure: ").append(this.procedure);
        sb.append(" , offering: ").append(this.offering);
        sb.append(" , feature: ").append(this.feature);
        sb.append(" , service: ").append(this.getService());
        sb.append(" , #observations: ").append(this.getObservationCount() >= 0L ? this.getObservationCount() : (long)this.observations.size());
        return sb.append(" ]").toString();
    }
}

