/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.List;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.ValueType;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.parameter.Parameter;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;

public abstract class AbstractDataRepository<D extends Data<?>, S extends DatasetEntity<?>, E extends DataEntity<?>, V extends AbstractValue<?>>
extends SessionAwareRepository
implements DataRepository<S, V> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data<? extends AbstractValue<?>> getData(String datasetId, DbQuery dbQuery) throws DataAccessException {
        Session session = this.getSession();
        try {
            DatasetDao<S> seriesDao = this.getSeriesDao(session);
            String id = ValueType.extractId((String)datasetId);
            DatasetEntity series = (DatasetEntity)seriesDao.getInstance(id, dbQuery);
            if (series.getService() == null) {
                series.setService(this.getServiceEntity());
            }
            D d = dbQuery.isExpanded() ? this.assembleDataWithReferenceValues(series, dbQuery, session) : this.assembleData(series, dbQuery, session);
            return d;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public V getFirstValue(S entity, Session session, DbQuery query) {
        DataDao<E> dao = this.createDataDao(session);
        E valueEntity = dao.getDataValueViaTimestart((DatasetEntity)entity, query);
        return this.createSeriesValueFor(valueEntity, entity, query);
    }

    @Override
    public V getLastValue(S entity, Session session, DbQuery query) {
        DataDao<E> dao = this.createDataDao(session);
        E valueEntity = dao.getDataValueViaTimeend((DatasetEntity)entity, query);
        return this.createSeriesValueFor(valueEntity, entity, query);
    }

    protected DatasetDao<S> getSeriesDao(Session session) {
        return new DatasetDao(session);
    }

    protected DataDao<E> createDataDao(Session session) {
        return new DataDao(session);
    }

    protected abstract V createSeriesValueFor(E var1, S var2, DbQuery var3);

    protected abstract D assembleData(S var1, DbQuery var2, Session var3) throws DataAccessException;

    protected abstract D assembleDataWithReferenceValues(S var1, DbQuery var2, Session var3) throws DataAccessException;

    protected boolean hasValidEntriesWithinRequestedTimespan(List<?> observations) {
        return observations.size() > 0;
    }

    protected boolean hasSingleValidReferenceValue(List<?> observations) {
        return observations.size() == 1;
    }

    protected void addGeometry(DataEntity<?> dataEntity, AbstractValue<?> value) {
        if (dataEntity.isSetGeometry()) {
            GeometryEntity geometry = dataEntity.getGeometryEntity();
            value.setGeometry(geometry.getGeometry(this.getDatabaseSrid()));
        }
    }

    protected void addValidTime(DataEntity<?> observation, AbstractValue<?> value) {
        if (observation.isSetValidStartTime() || observation.isSetValidEndTime()) {
            Long validFrom = observation.isSetValidStartTime() ? Long.valueOf(observation.getValidTimeStart().getTime()) : null;
            Long validUntil = observation.isSetValidEndTime() ? Long.valueOf(observation.getValidTimeEnd().getTime()) : null;
            value.setValidTime(new AbstractValue.ValidTime(validFrom, validUntil));
        }
    }

    protected void addParameters(DataEntity<?> observation, AbstractValue<?> value, DbQuery query) {
        if (observation.hasParameters()) {
            for (Parameter<?> parameter : observation.getParameters()) {
                value.addParameter(parameter.toValueMap(query.getLocale()));
            }
        }
    }
}

